/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio.wrapper;

import iso.std.iso_iec._24727.tech.schema.DisplayCapabilityType;
import iso.std.iso_iec._24727.tech.schema.IFDStatusType;
import iso.std.iso_iec._24727.tech.schema.KeyPadCapabilityType;
import iso.std.iso_iec._24727.tech.schema.SlotStatusType;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardNotPresentException;
import javax.smartcardio.CardTerminal;
import org.openecard.common.ifd.PACECapabilities;
import org.openecard.common.util.ByteUtils;
import org.openecard.ifd.scio.IFDException;
import org.openecard.ifd.scio.IFDUtils;
import org.openecard.ifd.scio.reader.ExecutePACERequest;
import org.openecard.ifd.scio.reader.ExecutePACEResponse;
import org.openecard.ifd.scio.wrapper.SCCard;
import org.openecard.ifd.scio.wrapper.SCChannel;
import org.openecard.ifd.scio.wrapper.SCWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCTerminal {
    private static final Logger _logger = LoggerFactory.getLogger(SCTerminal.class);
    private final CardTerminal terminal;
    private final SCWrapper scwrapper;
    private Boolean acoustic = null;
    private Boolean optic = null;
    private boolean dispCapRead = false;
    private DisplayCapabilityType dispCap = null;
    private boolean keyCapRead = false;
    private KeyPadCapabilityType keyCap = null;
    private List<PACECapabilities.PACECapability> PACECapabilities = null;
    private SCCard scCard = null;

    public SCTerminal(CardTerminal terminal, SCWrapper scwrapper) {
        this.terminal = terminal;
        this.scwrapper = scwrapper;
    }

    public String getName() {
        return this.terminal.getName();
    }

    public boolean isCardPresent() {
        try {
            return this.terminal.isCardPresent();
        }
        catch (CardException ex) {
            return false;
        }
    }

    public boolean isConnected() {
        Boolean result = this.scCard != null;
        return result;
    }

    public synchronized SCCard getCard() throws IFDException {
        if (this.scCard == null) {
            IFDException ex = new IFDException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/terminal#noCard", "No card inserted in terminal.");
            _logger.warn(ex.getMessage(), ex);
            throw ex;
        }
        return this.scCard;
    }

    public synchronized IFDStatusType getStatus() throws IFDException {
        try {
            IFDStatusType status = new IFDStatusType();
            status.setIFDName(this.getName());
            status.setConnected(true);
            SlotStatusType stype = new SlotStatusType();
            status.getSlotStatus().add(stype);
            boolean cardPresent = this.isCardPresent();
            stype.setCardAvailable(cardPresent);
            stype.setIndex(IFDUtils.getSlotIndex(this.getName()));
            if (cardPresent) {
                if (this.isConnected()) {
                    ATR atr = this.scCard.getATR();
                    stype.setATRorATS(atr.getBytes());
                } else {
                    Card c = this.terminal.connect("*");
                    ATR atr = c.getATR();
                    stype.setATRorATS(atr.getBytes());
                    c.disconnect(false);
                }
            }
            return status;
        }
        catch (Exception ex) {
            IFDException ifdex = new IFDException(ex);
            _logger.warn(ifdex.getMessage(), ifdex);
            throw ifdex;
        }
    }

    public boolean equals(String ifdName) {
        Boolean result = this.terminal.getName().equals(ifdName);
        return result;
    }

    public boolean equals(CardTerminal other) {
        Boolean result = this.terminal.getName().equals(other.getName());
        return result;
    }

    void updateTerminal() {
        if (!this.isCardPresent()) {
            this.scCard = null;
        } else {
            try {
                Card newCard;
                if (this.scCard != null && !this.scCard.equalCardObj(newCard = this.terminal.connect("*"))) {
                    this.scCard = null;
                }
            }
            catch (CardException ex) {
                this.scCard = null;
            }
        }
    }

    public synchronized SCChannel connect() throws IFDException {
        byte[] handle = this.scwrapper.createHandle(16);
        if (!this.isConnected()) {
            try {
                Card c = this.terminal.connect("*");
                this.scCard = new SCCard(c, this);
            }
            catch (CardNotPresentException ex) {
                IFDException ifdex = new IFDException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/terminal#noCard", ex.getMessage());
                _logger.warn(ifdex.getMessage(), ifdex);
                throw ifdex;
            }
            catch (CardException ex) {
                IFDException ifdex = new IFDException(ex);
                _logger.warn(ifdex.getMessage(), ifdex);
                throw ifdex;
            }
        }
        try {
            SCChannel scChannel = this.scCard.addChannel(handle);
            return scChannel;
        }
        catch (CardException ex) {
            IFDException ifdex = new IFDException(ex.getMessage());
            _logger.warn(ifdex.getMessage(), ifdex);
            throw ifdex;
        }
    }

    synchronized void disconnect() throws CardException {
        if (this.isConnected()) {
            this.scCard.disconnect();
        }
    }

    synchronized void removeCard() {
        this.scCard = null;
    }

    public synchronized boolean isAcousticSignal() throws IFDException {
        if (this.acoustic == null) {
            return false;
        }
        return this.acoustic;
    }

    public synchronized boolean isOpticalSignal() throws IFDException {
        if (this.acoustic == null) {
            return false;
        }
        return this.acoustic;
    }

    public synchronized DisplayCapabilityType getDisplayCapability() throws IFDException {
        if (!this.dispCapRead && this.isConnected()) {
            try {
                byte[] data;
                Map<Integer, Integer> features = this.getCard().getFeatureCodes();
                if (features.containsKey(17) && (data = this.getCard().controlCommand(features.get(17), new byte[0])) != null && data.length == 4) {
                    int lineLength = ByteUtils.toInteger(Arrays.copyOfRange(data, 0, 2));
                    int numLines = ByteUtils.toInteger(Arrays.copyOfRange(data, 2, 4));
                    if (lineLength > 0 && numLines > 0) {
                        this.dispCap = new DisplayCapabilityType();
                        this.dispCap.setIndex(BigInteger.ZERO);
                        this.dispCap.setColumns(BigInteger.valueOf(lineLength));
                        this.dispCap.setLines(BigInteger.valueOf(numLines));
                    }
                }
                this.dispCapRead = true;
            }
            catch (CardException ex) {
                throw new IFDException(ex);
            }
        }
        return this.dispCap;
    }

    public synchronized KeyPadCapabilityType getKeypadCapability() throws IFDException {
        if (!this.keyCapRead && this.isConnected()) {
            try {
                byte[] data;
                Map<Integer, Integer> features = this.getCard().getFeatureCodes();
                if (features.containsKey(10) && (data = this.getCard().controlCommand(features.get(10), new byte[0])) != null && data.length == 4) {
                    int wcdLayout = ByteUtils.toInteger(Arrays.copyOfRange(data, 0, 2));
                    byte entryValidation = data[2];
                    byte timeOut2 = data[3];
                }
                this.keyCapRead = true;
            }
            catch (CardException ex) {
                throw new IFDException(ex);
            }
        }
        return this.keyCap;
    }

    public synchronized byte[] executeCtrlCode(int featureCode, byte[] command) throws IFDException {
        if (this.isConnected()) {
            try {
                Map<Integer, Integer> features = this.getCard().getFeatureCodes();
                if (features.containsKey(featureCode)) {
                    Integer code = features.get(featureCode);
                    byte[] result = this.getCard().controlCommand(code, command);
                    return result;
                }
                throw new IFDException("The requested control code is not supported by the terminal");
            }
            catch (CardException ex) {
                throw new IFDException(ex);
            }
        }
        throw new IFDException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/dp#invalidChannelHandle", "No connection is established with the reader.");
    }

    private synchronized Integer getPaceCtrlCode() throws IFDException {
        if (this.isConnected()) {
            try {
                Map<Integer, Integer> features = this.getCard().getFeatureCodes();
                if (features.containsKey(32)) {
                    return features.get(32);
                }
            }
            catch (CardException ex) {
                throw new IFDException(ex);
            }
        }
        return null;
    }

    public synchronized boolean supportsPace() throws IFDException {
        return this.getPaceCtrlCode() != null;
    }

    public List<PACECapabilities.PACECapability> getPACECapabilities() throws IFDException {
        LinkedList<PACECapabilities.PACECapability> result = new LinkedList<PACECapabilities.PACECapability>();
        if (this.PACECapabilities == null) {
            if (this.isConnected() && this.supportsPace()) {
                int ctrlCode = this.getPaceCtrlCode();
                byte[] getCapabilityRequest = new ExecutePACERequest(ExecutePACERequest.Function.GetReaderPACECapabilities).toBytes();
                try {
                    byte[] response = this.getCard().controlCommand(ctrlCode, getCapabilityRequest);
                    ExecutePACEResponse paceResponse = new ExecutePACEResponse(response);
                    if (paceResponse.isError()) {
                        throw new IFDException(paceResponse.getResult());
                    }
                    PACECapabilities cap = new PACECapabilities(paceResponse.getData());
                    this.PACECapabilities = cap.getFeaturesEnum();
                    result.addAll(this.PACECapabilities);
                }
                catch (CardException e) {
                    IFDException ex = new IFDException(e);
                    throw ex;
                }
            }
        } else {
            result.addAll(this.PACECapabilities);
        }
        return Collections.unmodifiableList(result);
    }

    private synchronized Integer getPinCompareCtrlCode() throws IFDException {
        if (this.isConnected()) {
            try {
                Map<Integer, Integer> features = this.getCard().getFeatureCodes();
                if (features.containsKey(6)) {
                    return features.get(6);
                }
            }
            catch (CardException ex) {
                throw new IFDException(ex);
            }
        }
        return null;
    }

    public synchronized boolean supportsPinCompare() throws IFDException {
        return this.getPinCompareCtrlCode() != null;
    }
}

