/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.protocol.pace.crypto;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.openecard.bouncycastle.crypto.engines.AESEngine;
import org.openecard.bouncycastle.crypto.macs.CMac;
import org.openecard.bouncycastle.crypto.params.KeyParameter;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.util.ByteUtils;
import org.openecard.crypto.common.asn1.eac.PACESecurityInfos;
import org.openecard.crypto.common.asn1.utils.ObjectIdentifierUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthenticationToken {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationToken.class.getName());
    private byte[] token = new byte[8];
    private byte[] currentCAR;
    private byte[] previousCAR;
    private PACESecurityInfos psi;

    public AuthenticationToken(PACESecurityInfos psi) {
        this.psi = psi;
    }

    public void generateToken(byte[] keyMac, byte[] key) throws GeneralSecurityException {
        byte[] tmp = new byte[16];
        byte[] macData = this.getMACObject(key);
        CMac cMAC = new CMac(new AESEngine());
        cMAC.init(new KeyParameter(keyMac));
        cMAC.update(macData, 0, macData.length);
        cMAC.doFinal(tmp, 0);
        System.arraycopy(tmp, 0, this.token, 0, 8);
    }

    public boolean verifyToken(AuthenticationToken token, boolean specifiedCHAT) throws GeneralSecurityException {
        return this.verifyToken(token.toByteArray(), specifiedCHAT);
    }

    public boolean verifyToken(byte[] T_PICC, boolean specifiedCHAT) throws GeneralSecurityException {
        ByteArrayInputStream bais = new ByteArrayInputStream(T_PICC);
        byte tag = (byte)bais.read();
        byte size = (byte)bais.read();
        if (tag != 124 || (size & 0xFF) != bais.available()) {
            throw new GeneralSecurityException("Malformed authentication token");
        }
        tag = (byte)bais.read();
        size = (byte)bais.read();
        if (tag == -122 && (size & 0xFF) == 8) {
            byte[] buf = new byte[8];
            bais.read(buf, 0, 8);
            if (!ByteUtils.compare(buf, this.token)) {
                throw new GeneralSecurityException("Cannot verify authentication token");
            }
        } else {
            throw new GeneralSecurityException("Malformed authentication token");
        }
        tag = (byte)bais.read();
        size = (byte)bais.read();
        if (specifiedCHAT) {
            if (tag != -121 || size != 14) {
                throw new GeneralSecurityException("Malformed authentication token");
            }
            this.currentCAR = new byte[size];
            bais.read(this.currentCAR, 0, size);
            tag = (byte)bais.read();
            size = (byte)bais.read();
            if (bais.available() > 0) {
                if (tag == -120 && size == 14) {
                    this.previousCAR = new byte[size];
                    bais.read(this.previousCAR, 0, size);
                } else {
                    throw new GeneralSecurityException("Malformed authentication token");
                }
            }
        }
        if (bais.available() != 0) {
            throw new GeneralSecurityException("Malformed authentication token");
        }
        try {
            bais.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return true;
    }

    public byte[] toByteArray() {
        return this.token;
    }

    public byte[] getCurrentCAR() {
        return this.currentCAR;
    }

    public byte[] getPreviousCAR() {
        return this.previousCAR;
    }

    private byte[] getMACObject(byte[] key) throws GeneralSecurityException {
        byte[] ret = null;
        try {
            TLV keyObject = new TLV();
            keyObject.setTagNumWithClass((byte)-122);
            keyObject.setValue(ByteUtils.cutLeadingNullBytes(key));
            TLV oidObject = new TLV();
            oidObject.setTagNumWithClass((byte)6);
            oidObject.setValue(ObjectIdentifierUtils.getValue(this.psi.getPACEInfo().getProtocol()));
            oidObject.addToEnd(keyObject);
            TLV macObject = new TLV();
            macObject.setTagNum((byte)73);
            macObject.setTagClass(TagClass.APPLICATION);
            macObject.setChild(oidObject);
            ret = macObject.toBER(true);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            throw new GeneralSecurityException(e);
        }
        return ret;
    }
}

