/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openecard.common.I18n;
import org.openecard.gui.settings.ActionButtonListener;
import org.openecard.gui.settings.SettingsDialog;
import org.openecard.gui.swing.common.GUIDefaults;
import org.openecard.plugins.PluginAction;
import org.openecard.plugins.PluginInterface;
import org.openecard.plugins.manager.PluginManager;

final class PluginsListSelectionListener
implements ListSelectionListener {
    private final I18n lang = I18n.getTranslation("settings");
    private static final String SETTINGS = "settings.plugins.settings";
    private static final String ACTIONS = "settings.plugins.actions";
    private static final String INFORMATION = "settings.plugins.information";
    private static final String DESCRIPTION = "settings.plugins.description";
    private static final String ACTIONS_START = "settings.plugins.actions.start";
    private static final String DEACTIVATED = "settings.plugins.deactivated";
    private static final String ACTIVATED = "settings.plugins.activated";
    private static final String VERSION = "settings.plugins.version";
    private static final String ACTIVATE = "settings.plugins.activate";
    private static final String DEACTIVATE = "settings.plugins.deactivate";
    private static final String CURRENT_STATUS = "settings.plugins.current_status";
    private static final String SETTINGS_NOSETTINGS = "settings.plugins.settings.nosettings";
    private static final String NOACTIONS = "settings.plugins.noactions";
    private static final Icon OPENED_INDICATOR = GUIDefaults.getImage("ToggleText.selectedIcon");
    private static final Icon CLOSED_INDICATOR = GUIDefaults.getImage("ToggleText.icon");
    private final JList listPlugins;
    private final JPanel mainPanel;
    private final JPanel rightPane;
    private final int columnheight;
    private final Dimension dimension;
    private final Border defaultBorder;

    PluginsListSelectionListener(SettingsDialog settingsDialog, JList listPlugins) {
        this.listPlugins = listPlugins;
        this.rightPane = settingsDialog.getRightPane();
        this.mainPanel = settingsDialog.getMainPane();
        this.defaultBorder = settingsDialog.getDefaultBorder();
        this.columnheight = settingsDialog.getColumnheight();
        this.dimension = new Dimension(3 * settingsDialog.getColumnwidth(), settingsDialog.getColumnheight());
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        Object[] pluginsArray = PluginManager.getLoadedPlugins().keySet().toArray();
        PluginInterface plugin = (PluginInterface)pluginsArray[this.listPlugins.getSelectedIndex()];
        this.rightPane.removeAll();
        this.mainPanel.remove(this.rightPane);
        JTabbedPane tabbedPane = this.createTabbedPane(plugin);
        this.rightPane.add(tabbedPane);
        this.mainPanel.add(this.rightPane);
        this.mainPanel.validate();
        this.mainPanel.repaint();
    }

    private JTabbedPane createTabbedPane(PluginInterface plugin) {
        JTabbedPane tabbedPane = new JTabbedPane(1);
        tabbedPane.setBorder(this.defaultBorder);
        tabbedPane.setPreferredSize(this.dimension);
        tabbedPane.setBackground(Color.white);
        tabbedPane.setSize(this.dimension);
        tabbedPane.removeAll();
        tabbedPane.addTab(this.lang.translationForKey(INFORMATION, new Object[0]), this.createInformationPane(plugin));
        tabbedPane.addTab(this.lang.translationForKey(ACTIONS, new Object[0]), this.createActionsPane(plugin));
        tabbedPane.addTab(this.lang.translationForKey(SETTINGS, new Object[0]), this.createSettingsPane(plugin));
        return tabbedPane;
    }

    private Component createSettingsPane(PluginInterface plugin) {
        JPanel settingsPane = new JPanel();
        JLabel noSettings = new JLabel();
        noSettings.setText(this.lang.translationForKey(SETTINGS_NOSETTINGS, new Object[0]));
        noSettings.setBorder(this.defaultBorder);
        settingsPane.add(noSettings);
        return settingsPane;
    }

    private Component createInformationPane(final PluginInterface plugin) {
        JPanel informationPane = new JPanel();
        informationPane.setLayout(new BoxLayout(informationPane, 3));
        JPanel description = new JPanel();
        description.setLayout(new BoxLayout(description, 3));
        description.setBorder(this.defaultBorder);
        JLabel descriptionTitle = new JLabel();
        descriptionTitle.setText(this.lang.translationForKey(DESCRIPTION, new Object[0]));
        description.add(descriptionTitle);
        JLabel descriptionBody = new JLabel();
        descriptionBody.setText(plugin.getDescription());
        description.add(descriptionBody);
        informationPane.add(description);
        JLabel statusTitle = new JLabel();
        boolean status = PluginManager.getLoadedPlugins().get(plugin);
        statusTitle.setBorder(this.defaultBorder);
        String currentStatus = this.lang.translationForKey(CURRENT_STATUS, new Object[0]);
        String activated = this.lang.translationForKey(ACTIVATED, new Object[0]);
        String deactivated = this.lang.translationForKey(DEACTIVATED, new Object[0]);
        statusTitle.setText(currentStatus + (status ? activated : deactivated));
        informationPane.add(statusTitle);
        final JButton statusChangeButton = new JButton();
        statusChangeButton.setText(status ? this.lang.translationForKey(DEACTIVATE, new Object[0]) : this.lang.translationForKey(ACTIVATE, new Object[0]));
        statusChangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                boolean status = PluginManager.getLoadedPlugins().get(plugin);
                if (status) {
                    PluginManager.getInstance().deactivatePlugin(plugin);
                    statusChangeButton.setText(PluginsListSelectionListener.this.lang.translationForKey(PluginsListSelectionListener.ACTIVATE, new Object[0]));
                    PluginsListSelectionListener.this.valueChanged(null);
                } else {
                    PluginManager.getInstance().activatePlugin(plugin);
                    statusChangeButton.setText(PluginsListSelectionListener.this.lang.translationForKey(PluginsListSelectionListener.DEACTIVATE, new Object[0]));
                    PluginsListSelectionListener.this.valueChanged(null);
                }
            }
        });
        informationPane.add(statusChangeButton);
        JLabel version = new JLabel();
        version.setBorder(this.defaultBorder);
        version.setText(this.lang.translationForKey(VERSION, new Object[0]) + plugin.getVersion());
        informationPane.add(version);
        return informationPane;
    }

    private Component createActionsPane(PluginInterface plugin) {
        JPanel actionsPanel = new JPanel();
        actionsPanel.setLayout(new GridBagLayout());
        actionsPanel.setMinimumSize(new Dimension(0, this.columnheight));
        int i = 0;
        while (i < plugin.getActions().size()) {
            JPanel actionsPane = this.createActionPane(plugin.getActions().get(i), actionsPanel);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = i++;
            c.fill = 2;
            c.weightx = 1.0;
            actionsPanel.add((Component)actionsPane, c);
        }
        if (plugin.getActions().size() == 0) {
            JLabel noActions = new JLabel();
            noActions.setBorder(this.defaultBorder);
            noActions.setText(this.lang.translationForKey(NOACTIONS, new Object[0]));
            actionsPanel.add(noActions);
        }
        return actionsPanel;
    }

    private JPanel createActionPane(PluginAction action, JPanel actionsPanel) {
        final JPanel actionPane = new JPanel();
        final JButton button = new JButton(action.getName());
        final JTextArea text = new JTextArea(action.getDescription());
        final JButton startButton = new JButton(this.lang.translationForKey(ACTIONS_START, new Object[0]));
        startButton.addActionListener(new ActionButtonListener(action));
        text.setMargin(new Insets(0, 13, 0, 0));
        text.setEditable(false);
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setVisible(false);
        startButton.setVisible(false);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                text.setVisible(!text.isVisible());
                startButton.setVisible(!startButton.isVisible());
                button.setIcon(text.isVisible() ? OPENED_INDICATOR : CLOSED_INDICATOR);
                actionPane.revalidate();
                actionPane.doLayout();
                actionPane.repaint();
            }
        });
        button.setIcon(text.isVisible() ? OPENED_INDICATOR : CLOSED_INDICATOR);
        button.setOpaque(true);
        button.setFocusPainted(false);
        button.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        button.setHorizontalAlignment(2);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setBounds(0, 0, 0, 0);
        button.setContentAreaFilled(false);
        button.setHorizontalTextPosition(11);
        actionPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        actionPane.add((Component)button, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        actionPane.add((Component)text, gbc);
        gbc.gridx = 0;
        gbc.fill = 0;
        gbc.gridy = 2;
        actionPane.add((Component)startButton, gbc);
        return actionPane;
    }
}

