/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import iso.std.iso_iec._24727.tech.schema.IFDStatusType;
import iso.std.iso_iec._24727.tech.schema.SlotStatusType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IFDStatusDiff {
    private static final Logger _logger = LoggerFactory.getLogger(IFDStatusDiff.class);
    private final List<IFDStatusType> expected;
    private List<IFDStatusType> result;
    private List<IFDStatusType> deleted;

    public IFDStatusDiff(List<IFDStatusType> expected) {
        this.expected = expected;
    }

    public static IFDStatusDiff diff(List<IFDStatusType> expected, List<IFDStatusType> others, boolean withNew) {
        IFDStatusDiff diff = new IFDStatusDiff(expected);
        diff.diff(others, withNew);
        return diff;
    }

    public void diff(List<IFDStatusType> others, boolean withNew) {
        this.result = new LinkedList<IFDStatusType>();
        this.deleted = new LinkedList<IFDStatusType>(this.expected);
        for (IFDStatusType next : others) {
            String nextName = next.getIFDName();
            if (this.expectedContains(nextName)) {
                boolean thisCardB;
                IFDStatusType other = this.expectedGet(nextName);
                Boolean otherCard = other.isConnected();
                boolean otherCardB = otherCard == null ? false : otherCard;
                Boolean thisCard = next.isConnected();
                boolean bl = thisCardB = thisCard == null ? false : thisCard;
                if (thisCardB != otherCardB) {
                    this.result.add(next);
                } else if (other.getSlotStatus().size() == next.getSlotStatus().size()) {
                    for (SlotStatusType nextSlot : next.getSlotStatus()) {
                        BigInteger thisSlotIdx = nextSlot.getIndex();
                        SlotStatusType otherSlot = null;
                        for (SlotStatusType nextOtherSlot : other.getSlotStatus()) {
                            if (!thisSlotIdx.equals(nextOtherSlot.getIndex())) continue;
                            otherSlot = nextOtherSlot;
                            break;
                        }
                        if (otherSlot == null) {
                            this.result.add(next);
                            break;
                        }
                        if (nextSlot.isCardAvailable() != otherSlot.isCardAvailable()) {
                            this.result.add(next);
                            break;
                        }
                        byte[] nextATR = nextSlot.getATRorATS();
                        byte[] otherATR = otherSlot.getATRorATS();
                        if (nextATR == null && otherATR == null || IFDStatusDiff.arrayEquals(nextATR, otherATR)) continue;
                        this.result.add(next);
                        break;
                    }
                }
                this.deleted.remove(this.expectedGet(nextName));
                continue;
            }
            if (!withNew) continue;
            this.result.add(next);
        }
        this.merge(this.deleted);
    }

    private static boolean arrayEquals(byte[] a, byte[] b) {
        if (a == null && b == null) {
            return false;
        }
        boolean result = Arrays.equals(a, b);
        return result;
    }

    private IFDStatusType expectedGet(String ifdName) {
        for (IFDStatusType s : this.expected) {
            if (!s.getIFDName().equals(ifdName)) continue;
            return s;
        }
        return null;
    }

    private boolean expectedContains(String ifdName) {
        Boolean b = this.expectedGet(ifdName) != null;
        return b;
    }

    private List<IFDStatusType> merge(List<IFDStatusType> deleted) {
        ArrayList<IFDStatusType> states = new ArrayList<IFDStatusType>(this.result.size() + deleted.size());
        states.addAll(this.result);
        for (IFDStatusType next : deleted) {
            IFDStatusType s = new IFDStatusType();
            s.setIFDName(next.getIFDName());
            s.setConnected(Boolean.FALSE);
            for (SlotStatusType nextST : next.getSlotStatus()) {
                SlotStatusType st = new SlotStatusType();
                st.setIndex(nextST.getIndex());
                st.setCardAvailable(Boolean.FALSE);
                s.getSlotStatus().add(st);
            }
            states.add(s);
        }
        this.result = states;
        return states;
    }

    public boolean hasChanges() {
        return this.result != null && !this.result.isEmpty();
    }

    public List<IFDStatusType> result() {
        return this.result;
    }
}

