/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http.handler;

import java.io.IOException;
import java.net.URI;
import org.openecard.apache.http.HttpRequest;
import org.openecard.apache.http.HttpResponse;
import org.openecard.apache.http.RequestLine;
import org.openecard.apache.http.entity.ContentType;
import org.openecard.apache.http.entity.StringEntity;
import org.openecard.apache.http.protocol.HttpContext;
import org.openecard.control.ControlException;
import org.openecard.control.binding.http.HTTPException;
import org.openecard.control.binding.http.common.Http11Response;
import org.openecard.control.binding.http.handler.HttpControlHandler;
import org.openecard.control.module.status.GenericWaitForChangeHandler;
import org.openecard.control.module.status.StatusChangeRequest;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.openecard.ws.marshal.WSMarshallerFactory;
import org.openecard.ws.schema.StatusChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpWaitForChangeHandler
extends HttpControlHandler {
    private static final Logger logger = LoggerFactory.getLogger(HttpWaitForChangeHandler.class);
    private final WSMarshaller m;
    private final GenericWaitForChangeHandler genericWaitForChangeHandler;

    public HttpWaitForChangeHandler(GenericWaitForChangeHandler genericWaitForChangeHandler) {
        super("/waitForChange");
        this.genericWaitForChangeHandler = genericWaitForChangeHandler;
        try {
            this.m = WSMarshallerFactory.createInstance();
            this.m.removeAllTypeClasses();
            this.m.addXmlTypeClass(StatusChange.class);
        }
        catch (WSMarshallerException e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public StatusChangeRequest handleRequest(HttpRequest httpRequest) throws HTTPException {
        try {
            RequestLine requestLine = httpRequest.getRequestLine();
            if (requestLine.getMethod().equals("GET")) {
                URI requestURI = URI.create(requestLine.getUri());
                return this.genericWaitForChangeHandler.parseStatusChangeRequestURI(requestURI);
            }
            throw new HTTPException(405);
        }
        catch (HTTPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HTTPException(400, e.getMessage());
        }
    }

    public HttpResponse handleResponse(StatusChange statusChange) throws HTTPException {
        try {
            Http11Response httpResponse = new Http11Response(202);
            String xml = this.m.doc2str(this.m.marshal(statusChange));
            ContentType contentType = ContentType.create(ContentType.TEXT_XML.getMimeType(), "UTF-8");
            StringEntity entity = new StringEntity(xml, contentType);
            httpResponse.setEntity(entity);
            return httpResponse;
        }
        catch (Exception e) {
            throw new HTTPException(500, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws IOException {
        logger.debug("HTTP request: {}", (Object)request.toString());
        HttpResponse httpResponse = null;
        try {
            StatusChangeRequest statusRequest = this.handleRequest(request);
            StatusChange status = this.genericWaitForChangeHandler.getStatusChange(statusRequest);
            if (status == null) {
                String msg = "There is no event queue for the specified session identifier existing.";
                httpResponse = new Http11Response(400, msg);
            } else {
                httpResponse = this.handleResponse(status);
            }
            response.setParams(request.getParams());
        }
        catch (ControlException e) {
            block9: {
                httpResponse = new Http11Response(400);
                if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                    httpResponse.setEntity(new StringEntity(e.getMessage(), "UTF-8"));
                }
                if (!(e instanceof HTTPException)) break block9;
                httpResponse.setStatusCode(((HTTPException)e).getHTTPStatusCode());
            }
            Http11Response.copyHttpResponse(httpResponse, response);
            logger.debug("HTTP response: {}", (Object)response);
            logger.debug("HTTP request handled by: {}", (Object)this.getClass().getName());
        }
        catch (Exception e2) {
            httpResponse = new Http11Response(500);
            logger.error(e2.getMessage(), e2);
            {
                catch (Throwable throwable) {
                    Http11Response.copyHttpResponse(httpResponse, response);
                    logger.debug("HTTP response: {}", (Object)response);
                    logger.debug("HTTP request handled by: {}", (Object)this.getClass().getName());
                    throw throwable;
                }
            }
            Http11Response.copyHttpResponse(httpResponse, response);
            logger.debug("HTTP response: {}", (Object)response);
            logger.debug("HTTP request handled by: {}", (Object)this.getClass().getName());
        }
        Http11Response.copyHttpResponse(httpResponse, response);
        logger.debug("HTTP response: {}", (Object)response);
        logger.debug("HTTP request handled by: {}", (Object)this.getClass().getName());
    }
}

