/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing;

import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.openecard.common.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NavigationBar
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(NavigationBar.class);
    private static final long serialVersionUID = 1L;
    private final I18n lang = I18n.getTranslation("gui");
    private JButton backButton;
    private JButton nextButton;
    private JButton cancelButton;
    private int numSteps;

    public NavigationBar(int numSteps) {
        this.numSteps = numSteps;
        this.initializeComponents();
        this.initializeLayout();
    }

    public void registerEvents(ActionListener eventSink) {
        this.backButton.addActionListener(eventSink);
        this.nextButton.addActionListener(eventSink);
        this.cancelButton.addActionListener(eventSink);
    }

    private void initializeComponents() {
        this.backButton = new JButton(this.lang.translationForKey("Button.back", new Object[0]));
        this.backButton.setActionCommand("Button.back");
        this.backButton.setVisible(false);
        this.nextButton = new JButton(this.lang.translationForKey("Button.next", new Object[0]));
        this.nextButton.setActionCommand("Button.next");
        if (this.numSteps == 1) {
            this.nextButton.setText(this.lang.translationForKey("Button.finish", new Object[0]));
        }
        this.cancelButton = new JButton(this.lang.translationForKey("Button.cancel", new Object[0]));
        this.cancelButton.setActionCommand("Button.cancel");
    }

    private void initializeLayout() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(false);
        GroupLayout.SequentialGroup hg = layout.createSequentialGroup();
        hg.addComponent(this.backButton, 60, 60, 150);
        hg.addComponent(this.nextButton, 60, 60, 150);
        hg.addComponent(this.cancelButton, 60, 60, 150);
        layout.setHorizontalGroup(hg);
        GroupLayout.ParallelGroup vg = layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
        vg.addComponent(this.backButton);
        vg.addComponent(this.nextButton);
        vg.addComponent(this.cancelButton);
        layout.setVerticalGroup(vg);
    }

    public void lockControls() {
        this.backButton.setEnabled(false);
        this.nextButton.setEnabled(false);
    }

    public void unlockControls() {
        this.backButton.setEnabled(true);
        this.nextButton.setEnabled(true);
    }

    public void selectIdx(int nextIdx) {
        if (nextIdx == 0) {
            this.backButton.setVisible(false);
        } else {
            this.backButton.setVisible(true);
        }
        if (nextIdx == this.numSteps - 1) {
            this.nextButton.setText(this.lang.translationForKey("Button.finish", new Object[0]));
        } else {
            this.nextButton.setText(this.lang.translationForKey("Button.next", new Object[0]));
        }
    }

    @Override
    public boolean hasFocus() {
        return this.backButton.hasFocus() || this.nextButton.hasFocus() || this.cancelButton.hasFocus();
    }
}

