/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.settings;

import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openecard.gui.settings.PluginsListSelectionListener;
import org.openecard.gui.settings.SettingsDialog;
import org.openecard.plugins.manager.PluginManager;

final class PreferencesListSelectionListener
implements ListSelectionListener {
    private final SettingsDialog settingsDialog;
    private JPanel mainPanel;
    private JPanel middelListPane;
    private JList listPlugins;
    private JScrollPane listScrollerPlugins;

    PreferencesListSelectionListener(SettingsDialog settingsDialog) {
        this.settingsDialog = settingsDialog;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.mainPanel = this.settingsDialog.getMainPane();
        this.middelListPane = this.settingsDialog.getMiddleListPane();
        this.mainPanel.remove(this.middelListPane);
        this.middelListPane.removeAll();
        this.listScrollerPlugins = this.createPluginsPane();
        this.middelListPane.add(this.listScrollerPlugins);
        this.mainPanel.add(this.settingsDialog.getMiddleListPane());
        this.mainPanel.validate();
        this.mainPanel.repaint();
    }

    private JScrollPane createPluginsPane() {
        Object[] pluginsArray = PluginManager.getLoadedPlugins().keySet().toArray();
        this.listPlugins = new JList<Object>(pluginsArray);
        this.listPlugins.setSelectionMode(0);
        this.listPlugins.setLayoutOrientation(0);
        this.listPlugins.setVisibleRowCount(-1);
        this.listPlugins.addListSelectionListener(new PluginsListSelectionListener(this.settingsDialog, this.listPlugins));
        this.listScrollerPlugins = new JScrollPane(this.listPlugins);
        this.listScrollerPlugins.setPreferredSize(this.settingsDialog.getColumnDimension());
        return this.listScrollerPlugins;
    }
}

