/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.eac;

import java.security.spec.AlgorithmParameterSpec;
import org.openecard.crypto.common.asn1.eac.AlgorithmIdentifier;
import org.openecard.crypto.common.asn1.eac.CADomainParameterInfo;
import org.openecard.crypto.common.asn1.eac.CAInfo;
import org.openecard.crypto.common.asn1.eac.CASecurityInfos;
import org.openecard.crypto.common.asn1.eac.ExplicitDomainParameters;
import org.openecard.crypto.common.asn1.eac.StandardizedDomainParameters;

public final class CADomainParameter {
    private AlgorithmParameterSpec domainParameter;
    private CASecurityInfos csi;
    private CAInfo ci;

    public CADomainParameter(CASecurityInfos csi) {
        this.csi = csi;
        this.ci = csi.getCAInfo();
        this.loadParameters();
    }

    public CADomainParameter(CASecurityInfos csi, AlgorithmParameterSpec domainParameter) {
        this.csi = csi;
        this.ci = csi.getCAInfo();
        this.domainParameter = domainParameter;
    }

    public AlgorithmParameterSpec getParameter() {
        return this.domainParameter;
    }

    public void setParameter(AlgorithmParameterSpec domainParameter) {
        this.domainParameter = domainParameter;
    }

    public boolean isDH() {
        return this.ci.isDH();
    }

    public boolean isECDH() {
        return this.ci.isECDH();
    }

    private void loadParameters() {
        CADomainParameterInfo cdp = this.csi.getCADomainParameterInfo();
        AlgorithmIdentifier ai = cdp.getDomainParameter();
        if (ai.getObjectIdentifier().equals("0.4.0.127.0.7.1.2")) {
            int index = Integer.parseInt(ai.getParameters().toString());
            this.domainParameter = new StandardizedDomainParameters(index).getParameter();
        } else {
            this.domainParameter = new ExplicitDomainParameters(ai).getParameter();
        }
        if (this.domainParameter == null) {
            throw new IllegalArgumentException("Cannot load domain parameter");
        }
    }
}

