/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio.wrapper;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nonnull;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import org.openecard.ifd.scio.EventListener;
import org.openecard.ifd.scio.IFDException;
import org.openecard.ifd.scio.reader.PCSCFeatures;
import org.openecard.ifd.scio.wrapper.ByteArrayComparator;
import org.openecard.ifd.scio.wrapper.SCChannel;
import org.openecard.ifd.scio.wrapper.SCTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCCard {
    private static final Logger _logger = LoggerFactory.getLogger(SCCard.class);
    private final Card card;
    private final SCTerminal terminal;
    private Map<Integer, Integer> featureCodes;
    private final ConcurrentSkipListMap<byte[], SCChannel> scChannels;

    public SCCard(Card card, SCTerminal terminal) {
        this.card = card;
        this.terminal = terminal;
        this.scChannels = new ConcurrentSkipListMap(new ByteArrayComparator());
    }

    public byte[] controlCommand(int controlCode, byte[] commandData) throws CardException {
        EventListener.pause();
        byte[] result = this.card.transmitControlCommand(controlCode, commandData);
        return result;
    }

    @Nonnull
    public Map<Integer, Integer> getFeatureCodes() throws CardException {
        if (this.featureCodes == null) {
            int code = PCSCFeatures.GET_FEATURE_REQUEST_CTLCODE();
            try {
                byte[] response = this.controlCommand(code, new byte[0]);
                this.featureCodes = PCSCFeatures.featureMapFromRequest(response);
            }
            catch (CardException ex) {
                _logger.warn("Unable to request features from reader.", ex);
                this.featureCodes = new HashMap<Integer, Integer>();
            }
        }
        return this.featureCodes;
    }

    public String getProtocol() {
        String p = this.card.getProtocol();
        if (p.equals("T=0")) {
            return "urn:iso:std:iso-iec:7816:-3:tech:protocols:T-equals-0";
        }
        if (p.equals("T=1")) {
            return "urn:iso:std:iso-iec:7816:-3:tech:protocols:T-equals-1";
        }
        return null;
    }

    public ATR getATR() {
        return this.card.getATR();
    }

    public synchronized SCChannel getChannel(byte[] handle) throws IFDException {
        SCChannel ch = this.scChannels.get(handle);
        if (ch == null) {
            IFDException ex = new IFDException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", "No such slot handle.");
            _logger.debug(ex.getMessage(), ex);
            throw ex;
        }
        return ch;
    }

    public synchronized void closeChannel(byte[] handle, boolean reset) throws IFDException {
        SCChannel ch = this.getChannel(handle);
        try {
            ch.close();
            this.scChannels.remove(handle);
            if (this.scChannels.isEmpty()) {
                this.terminal.removeCard();
                this.card.disconnect(reset);
            }
        }
        catch (CardException ex) {
            IFDException ifdex = new IFDException(ex);
            _logger.warn(ifdex.getMessage(), ifdex);
            throw ifdex;
        }
    }

    public SCChannel addChannel(byte[] handle) throws CardException {
        CardChannel channel = this.card.getBasicChannel();
        SCChannel scChannel = new SCChannel(channel, handle);
        this.scChannels.put(handle, scChannel);
        return scChannel;
    }

    synchronized void disconnect() throws CardException {
        this.card.disconnect(true);
    }

    public void beginExclusive() throws CardException {
        this.card.beginExclusive();
    }

    public void endExclusive() throws CardException {
        this.card.endExclusive();
    }

    public boolean equalCardObj(Card other) {
        return this.card == other;
    }
}

