/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.GenericPrivateKeyObject;
import org.openecard.common.tlv.iso7816.PrivateECKeyAttribute;
import org.openecard.common.tlv.iso7816.PrivateRSAKeyAttribute;
import org.openecard.common.tlv.iso7816.TLVType;

public class PrivateKeyChoice
extends TLVType {
    private GenericPrivateKeyObject<PrivateRSAKeyAttribute> privateRSAKey;
    private GenericPrivateKeyObject<PrivateECKeyAttribute> privateECKey;
    private GenericPrivateKeyObject<TLV> privateDHKey;
    private GenericPrivateKeyObject<TLV> privateDSAKey;
    private GenericPrivateKeyObject<TLV> privateKEAKey;
    private GenericPrivateKeyObject<TLV> genericPrivateKey;
    private TLV ext;

    public PrivateKeyChoice(TLV tlv) throws TLVException {
        super(tlv);
        Parser p = new Parser(tlv);
        if (p.match(new Tag(TagClass.UNIVERSAL, false, 16L))) {
            this.privateRSAKey = new GenericPrivateKeyObject<PrivateRSAKeyAttribute>(p.next(0), PrivateRSAKeyAttribute.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 0L))) {
            this.privateECKey = new GenericPrivateKeyObject<PrivateECKeyAttribute>(p.next(0), PrivateECKeyAttribute.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 1L))) {
            this.privateDHKey = new GenericPrivateKeyObject<TLV>(p.next(0), TLV.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 2L))) {
            this.privateDSAKey = new GenericPrivateKeyObject<TLV>(p.next(0), TLV.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 3L))) {
            this.privateKEAKey = new GenericPrivateKeyObject<TLV>(p.next(0), TLV.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 4L))) {
            this.genericPrivateKey = new GenericPrivateKeyObject<TLV>(p.next(0), TLV.class);
        } else {
            this.ext = p.next(0);
        }
    }
}

