/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.definition;

import java.util.Arrays;
import org.openecard.gui.definition.IDTrait;
import org.openecard.gui.definition.InfoUnit;
import org.openecard.gui.definition.InfoUnitElementType;
import org.openecard.gui.definition.InputInfoUnit;
import org.openecard.gui.definition.OutputInfoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SignatureField
extends IDTrait
implements InputInfoUnit,
OutputInfoUnit {
    private static final Logger _logger = LoggerFactory.getLogger(SignatureField.class);
    private String text;
    private byte[] value;

    public SignatureField(String id) {
        super(id);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public byte[] getValue() {
        return this.value == null ? null : Arrays.copyOf(this.value, this.value.length);
    }

    public void setValue(byte[] value) {
        this.value = Arrays.copyOf(value, value.length);
    }

    @Override
    public InfoUnitElementType type() {
        return InfoUnitElementType.SIGNAUTRE_FIELD;
    }

    @Override
    public void copyContentFrom(InfoUnit origin) {
        if (!this.getClass().equals(origin.getClass())) {
            _logger.warn("Trying to copy content from type {} to type {}.", (Object)origin.getClass(), (Object)this.getClass());
            return;
        }
        SignatureField other = (SignatureField)origin;
        this.text = other.text;
        if (other.value != null) {
            this.value = Arrays.copyOf(other.value, other.value.length);
        }
    }
}

