/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.event;

import iso.std.iso_iec._24727.tech.schema.ChannelHandleType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.GetStatus;
import iso.std.iso_iec._24727.tech.schema.GetStatusResponse;
import iso.std.iso_iec._24727.tech.schema.IFDStatusType;
import iso.std.iso_iec._24727.tech.schema.SlotStatusType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openecard.common.WSHelper;
import org.openecard.common.enums.EventType;
import org.openecard.common.interfaces.Environment;
import org.openecard.common.interfaces.EventCallback;
import org.openecard.common.interfaces.EventFilter;
import org.openecard.common.util.ValueGenerators;
import org.openecard.event.Dispatcher;
import org.openecard.event.EventRunner;
import org.openecard.event.Recognizer;
import org.openecard.recognition.CardRecognition;
import org.openecard.recognition.RecognitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManager
implements org.openecard.common.interfaces.EventManager {
    private static final Logger _logger = LoggerFactory.getLogger(EventManager.class);
    protected final CardRecognition cr;
    protected final Environment env;
    protected final byte[] ctx;
    protected final String sessionId;
    protected final boolean recognize;
    private final Dispatcher dispatcher;
    protected ExecutorService threadPool;
    private Future watcher;

    public EventManager(CardRecognition cr, Environment env, byte[] ctx) {
        this.cr = cr;
        this.recognize = cr != null;
        this.env = env;
        this.ctx = ctx;
        this.sessionId = ValueGenerators.generateSessionID();
        this.dispatcher = new Dispatcher(this);
    }

    protected List<IFDStatusType> ifdStatus() throws WSHelper.WSException {
        GetStatus status = new GetStatus();
        status.setContextHandle(this.ctx);
        GetStatusResponse statusResponse = this.env.getIFD().getStatus(status);
        WSHelper.checkResult(statusResponse);
        List<IFDStatusType> result = statusResponse.getIFDStatus();
        return result;
    }

    private ConnectionHandleType makeConnectionHandle(String ifdName) {
        return this.makeConnectionHandle(ifdName, null, null);
    }

    private ConnectionHandleType makeConnectionHandle(String ifdName, BigInteger slotIdx) {
        return this.makeConnectionHandle(ifdName, slotIdx, null);
    }

    private ConnectionHandleType makeConnectionHandle(String ifdName, ConnectionHandleType.RecognitionInfo info) {
        return this.makeConnectionHandle(ifdName, null, info);
    }

    private ConnectionHandleType makeConnectionHandle(String ifdName, BigInteger slotIdx, ConnectionHandleType.RecognitionInfo info) {
        ChannelHandleType chan = new ChannelHandleType();
        chan.setSessionIdentifier(this.sessionId);
        ConnectionHandleType cHandle = new ConnectionHandleType();
        cHandle.setChannelHandle(chan);
        cHandle.setContextHandle(this.ctx);
        cHandle.setIFDName(ifdName);
        cHandle.setSlotIndex(slotIdx);
        cHandle.setRecognitionInfo(info);
        return cHandle;
    }

    protected ConnectionHandleType recognizeSlot(String ifdName, SlotStatusType status, boolean withRecognition) {
        ConnectionHandleType.RecognitionInfo rInfo = null;
        if (this.recognize && withRecognition) {
            try {
                rInfo = this.cr.recognizeCard(ifdName, status.getIndex());
            }
            catch (RecognitionException ex) {
                // empty catch block
            }
        }
        if (rInfo == null) {
            rInfo = new ConnectionHandleType.RecognitionInfo();
            rInfo.setCardType("http://bsi.bund.de/cif/unknown");
            rInfo.setCardIdentifier(status.getATRorATS());
            XMLGregorianCalendar cal = null;
            try {
                cal = DatatypeFactory.newInstance().newXMLGregorianCalendar();
            }
            catch (DatatypeConfigurationException ex) {
                // empty catch block
            }
            rInfo.setCaptureTime(cal);
        }
        return this.makeConnectionHandle(ifdName, status.getIndex(), rInfo);
    }

    private IFDStatusType getCorresponding(String ifdName, List<IFDStatusType> statuses) {
        for (IFDStatusType next : statuses) {
            if (!next.getIFDName().equals(ifdName)) continue;
            return next;
        }
        return null;
    }

    private SlotStatusType getCorresponding(BigInteger idx, List<SlotStatusType> statuses) {
        for (SlotStatusType next : statuses) {
            if (!next.getIndex().equals(idx)) continue;
            return next;
        }
        return null;
    }

    private void sendAsyncEvents(String ifdName, SlotStatusType nextSlot, EventType ... types) {
        this.threadPool.submit(new Recognizer(this, ifdName, nextSlot, types));
    }

    protected void sendEvents(List<IFDStatusType> oldS, List<IFDStatusType> changed) {
        for (IFDStatusType next : changed) {
            IFDStatusType counterPart = this.getCorresponding(next.getIFDName(), oldS);
            if (counterPart == null) {
                this.notify(EventType.TERMINAL_ADDED, this.makeConnectionHandle(next.getIFDName()));
                counterPart = new IFDStatusType();
                counterPart.setIFDName(next.getIFDName());
            }
            for (SlotStatusType nextSlot : next.getSlotStatus()) {
                SlotStatusType counterPartSlot = this.getCorresponding(nextSlot.getIndex(), counterPart.getSlotStatus());
                if (counterPartSlot == null) {
                    if (!nextSlot.isCardAvailable()) continue;
                    this.sendAsyncEvents(next.getIFDName(), nextSlot, EventType.CARD_INSERTED, EventType.CARD_RECOGNIZED);
                    continue;
                }
                if (nextSlot.isCardAvailable() != counterPartSlot.isCardAvailable()) {
                    if (nextSlot.isCardAvailable()) {
                        this.sendAsyncEvents(next.getIFDName(), nextSlot, EventType.CARD_INSERTED, EventType.CARD_RECOGNIZED);
                        continue;
                    }
                    this.notify(EventType.CARD_REMOVED, this.makeConnectionHandle(next.getIFDName(), nextSlot.getIndex()));
                    continue;
                }
                if (!nextSlot.isCardAvailable() || Arrays.equals(nextSlot.getATRorATS(), counterPartSlot.getATRorATS())) continue;
                this.sendAsyncEvents(next.getIFDName(), nextSlot, EventType.CARD_RECOGNIZED);
            }
            if (next.isConnected().booleanValue()) continue;
            this.notify(EventType.TERMINAL_REMOVED, this.makeConnectionHandle(next.getIFDName()));
        }
    }

    @Override
    public synchronized Object initialize() {
        this.threadPool = Executors.newCachedThreadPool();
        this.watcher = this.threadPool.submit(new EventRunner(this));
        return new ArrayList();
    }

    @Override
    public synchronized void terminate() {
        this.watcher.cancel(true);
        this.threadPool.shutdown();
    }

    protected synchronized void notify(EventType eventType, Object eventData) {
        this.dispatcher.notify(eventType, eventData);
    }

    @Override
    public void register(EventCallback callback, EventFilter filter) {
        this.dispatcher.add(callback, filter);
    }

    @Override
    public void register(EventCallback callback, EventType type) {
        this.dispatcher.add(callback, type);
    }

    @Override
    public void register(@Nonnull EventCallback callback, @Nonnull List<EventType> types) {
        this.dispatcher.add(callback, types.toArray(new EventType[types.size()]));
    }

    @Override
    public synchronized void registerAllEvents(EventCallback callback) {
        this.dispatcher.add(callback);
    }

    @Override
    public void unregister(EventCallback callback) {
        this.dispatcher.del(callback);
    }
}

