/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.module.tctoken;

import generated.TCTokenType;
import iso.std.iso_iec._24727.tech.schema.CardApplicationConnect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationConnectResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPath;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPathResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPathType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.StartPAOSResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openecard.bouncycastle.crypto.tls.Certificate;
import org.openecard.common.DynamicContext;
import org.openecard.common.I18n;
import org.openecard.common.WSHelper;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.interfaces.DispatcherException;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.common.util.HttpRequestLineUtils;
import org.openecard.common.util.Pair;
import org.openecard.common.util.Promise;
import org.openecard.common.util.TR03112Utils;
import org.openecard.control.ControlException;
import org.openecard.control.module.tctoken.PAOSTask;
import org.openecard.control.module.tctoken.TCTokenException;
import org.openecard.control.module.tctoken.TCTokenFactory;
import org.openecard.control.module.tctoken.TCTokenGrabber;
import org.openecard.control.module.tctoken.TCTokenRequest;
import org.openecard.control.module.tctoken.TCTokenResponse;
import org.openecard.control.module.tctoken.gui.InsertCardDialog;
import org.openecard.control.module.tctoken.hacks.ObjectTag;
import org.openecard.crypto.common.asn1.cvc.CertificateDescription;
import org.openecard.gui.UserConsent;
import org.openecard.recognition.CardRecognition;
import org.openecard.transport.paos.PAOSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericTCTokenHandler {
    private static final Logger logger = LoggerFactory.getLogger(GenericTCTokenHandler.class);
    private final I18n lang = I18n.getTranslation("tctoken");
    private final CardStateMap cardStates;
    private final Dispatcher dispatcher;
    private final UserConsent gui;
    private final CardRecognition rec;

    public GenericTCTokenHandler(CardStateMap cardStates, Dispatcher dispatcher, UserConsent gui, CardRecognition rec) {
        this.cardStates = cardStates;
        this.dispatcher = dispatcher;
        this.gui = gui;
        this.rec = rec;
    }

    public TCTokenRequest parseRequestURI(URI requestURI) throws UnsupportedEncodingException, TCTokenException {
        String queryStr = requestURI.getRawQuery();
        Map<String, String> queries = HttpRequestLineUtils.transform(queryStr);
        if (queries.containsKey("tcTokenURL")) {
            TCTokenRequest result = this.parseTCTokenRequestURI(queries);
            result.setTokenFromObject(false);
            return result;
        }
        if (queries.containsKey("activationObject")) {
            TCTokenRequest result = this.parseObjectURI(queries);
            result.setTokenFromObject(true);
            return result;
        }
        throw new TCTokenException("No suitable set of parameters given in the request.");
    }

    private TCTokenRequest parseTCTokenRequestURI(Map<String, String> queries) throws TCTokenException {
        TCTokenRequest tcTokenRequest = new TCTokenRequest();
        for (Map.Entry<String, String> next : queries.entrySet()) {
            String k = next.getKey();
            String v = next.getValue();
            if (k.equals("tcTokenURL")) {
                if (v != null && !v.isEmpty()) {
                    try {
                        URL tcTokenURL = new URL(v);
                        Pair<TCTokenType, List<Pair<URL, Certificate>>> token = TCTokenFactory.generateTCToken(tcTokenURL);
                        tcTokenRequest.setTCToken((TCTokenType)token.p1);
                        tcTokenRequest.setCertificates((List)token.p2);
                        tcTokenRequest.setTCTokenURL(tcTokenURL);
                        continue;
                    }
                    catch (MalformedURLException ex) {
                        String msg = "The tcTokenURL parameter contains an invalid URL: " + v;
                        throw new TCTokenException(msg, ex);
                    }
                    catch (IOException ex) {
                        throw new TCTokenException("Failed to fetch TCToken.", ex);
                    }
                }
                throw new TCTokenException("Parameter tcTokenURL contains no value.");
            }
            if (k.equals("ifdName")) {
                if (v != null && !v.isEmpty()) {
                    tcTokenRequest.setIFDName(v);
                    continue;
                }
                throw new TCTokenException("Parameter ifdName contains no value.");
            }
            if (k.equals("contextHandle")) {
                if (v != null && !v.isEmpty()) {
                    tcTokenRequest.setContextHandle(v);
                    continue;
                }
                throw new TCTokenException("Parameter contextHandle contains no value.");
            }
            if (k.equals("slotIndex")) {
                if (v != null && !v.isEmpty()) {
                    tcTokenRequest.setSlotIndex(v);
                    continue;
                }
                throw new TCTokenException("Parameter slotIndex contains no value.");
            }
            if (k.equals("cardType")) {
                if (v != null && !v.isEmpty()) {
                    tcTokenRequest.setCardType(v);
                    continue;
                }
                throw new TCTokenException("Parameter cardType contains no value.");
            }
            logger.info("Unknown query element: {}", (Object)k);
        }
        return tcTokenRequest;
    }

    private TCTokenRequest parseObjectURI(Map<String, String> queries) throws TCTokenException {
        TCTokenRequest tcTokenRequest = new TCTokenRequest();
        for (Map.Entry<String, String> next : queries.entrySet()) {
            String k = next.getKey();
            String v = next.getValue();
            if ("activationObject".equals(k)) {
                TCTokenType token = TCTokenFactory.generateTCToken(v);
                tcTokenRequest.setTCToken(token);
                continue;
            }
            if (!"serverCertificate".equals(k)) continue;
        }
        return tcTokenRequest;
    }

    private ConnectionHandleType getFirstHandle(String type) {
        String cardName = this.rec.getTranslatedCardName(type);
        ConnectionHandleType conHandle = new ConnectionHandleType();
        ConnectionHandleType.RecognitionInfo recInfo = new ConnectionHandleType.RecognitionInfo();
        recInfo.setCardType(type);
        conHandle.setRecognitionInfo(recInfo);
        Set<CardStateEntry> entries = this.cardStates.getMatchingEntries(conHandle);
        if (entries.isEmpty()) {
            InsertCardDialog uc = new InsertCardDialog(this.gui, this.cardStates, type, cardName);
            return uc.show();
        }
        return entries.iterator().next().handleCopy();
    }

    private TCTokenResponse doPAOS(TCTokenRequest tokenRequest, ConnectionHandleType connectionHandle) throws PAOSException, DispatcherException {
        TCTokenType token = tokenRequest.getTCToken();
        try {
            CardApplicationPath appPath = new CardApplicationPath();
            appPath.setCardAppPathRequest(connectionHandle);
            CardApplicationPathResponse appPathRes = (CardApplicationPathResponse)this.dispatcher.deliver(appPath);
            WSHelper.checkResult(appPathRes);
            CardApplicationConnect appConnect = new CardApplicationConnect();
            List<CardApplicationPathType> pathRes = appPathRes.getCardAppPathResultSet().getCardApplicationPathResult();
            appConnect.setCardApplicationPath(pathRes.get(0));
            CardApplicationConnectResponse appConnectRes = (CardApplicationConnectResponse)this.dispatcher.deliver(appConnect);
            connectionHandle = appConnectRes.getConnectionHandle();
            WSHelper.checkResult(appConnectRes);
            PAOSTask task = new PAOSTask(this.dispatcher, connectionHandle, tokenRequest);
            FutureTask<StartPAOSResponse> paosTask = new FutureTask<StartPAOSResponse>(task);
            Thread paosThread = new Thread(paosTask, "PAOS");
            paosThread.start();
            if (!tokenRequest.isTokenFromObject()) {
                paosTask.get();
            }
            TCTokenResponse response = new TCTokenResponse();
            response.setRefreshAddress(new URL(token.getRefreshAddress()));
            response.setResult(WSHelper.makeResultOK());
            return response;
        }
        catch (WSHelper.WSException ex) {
            String msg = "Failed to connect to card.";
            logger.error(msg, ex);
            throw new DispatcherException(msg, ex);
        }
        catch (InvocationTargetException ex) {
            logger.error(ex.getMessage(), ex);
            throw new DispatcherException(ex);
        }
        catch (MalformedURLException ex) {
            logger.error(ex.getMessage(), ex);
            throw new PAOSException(ex);
        }
        catch (InterruptedException ex) {
            logger.error(ex.getMessage(), ex);
            throw new PAOSException(ex);
        }
        catch (ExecutionException ex) {
            logger.error(ex.getMessage(), ex);
            if (ex.getCause() instanceof PAOSException) {
                throw (PAOSException)ex.getCause();
            }
            if (ex.getCause() instanceof DispatcherException) {
                throw (DispatcherException)ex.getCause();
            }
            throw new PAOSException(ex);
        }
    }

    public TCTokenResponse handleActivate(TCTokenRequest request) {
        boolean isObjectActivation;
        DynamicContext dynCtx = DynamicContext.getInstance("tr03112");
        boolean performChecks = ObjectTag.isPerformTR03112Checks(request);
        if (!performChecks) {
            logger.warn("Checks according to BSI TR03112 3.4.2, 3.4.4 (TCToken specific) and 3.4.5 are disabled.");
        }
        boolean bl = isObjectActivation = request.getTCTokenURL() == null;
        if (isObjectActivation) {
            logger.warn("Checks according to BSI TR03112 3.4.4 (TCToken specific) are disabled.");
        }
        dynCtx.put("tctoken_checks", performChecks);
        dynCtx.put("object_activation", isObjectActivation);
        dynCtx.put("tctoken_server_certificates", request.getCertificates());
        dynCtx.put("TCTokenURL", request.getTCTokenURL());
        ConnectionHandleType connectionHandle = null;
        TCTokenResponse response = new TCTokenResponse();
        byte[] requestedContextHandle = request.getContextHandle();
        String ifdName = request.getIFDName();
        BigInteger requestedSlotIndex = request.getSlotIndex();
        if (requestedContextHandle == null || ifdName == null || requestedSlotIndex == null) {
            connectionHandle = this.getFirstHandle(request.getCardType());
        } else {
            ConnectionHandleType requestedHandle = new ConnectionHandleType();
            requestedHandle.setContextHandle(requestedContextHandle);
            requestedHandle.setIFDName(ifdName);
            requestedHandle.setSlotIndex(requestedSlotIndex);
            Set<CardStateEntry> matchingHandles = this.cardStates.getMatchingEntries(requestedHandle);
            if (!matchingHandles.isEmpty()) {
                connectionHandle = matchingHandles.toArray(new CardStateEntry[0])[0].handleCopy();
            }
        }
        if (connectionHandle == null) {
            String msg = "No card available for the given ConnectionHandle.";
            logger.error(msg);
            response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#cancellationByUser", msg));
            return response;
        }
        try {
            response = this.doPAOS(request, connectionHandle);
            response = this.determineRefreshURL(request, response);
            return response;
        }
        catch (IOException w) {
            logger.error(w.getMessage(), w);
            response.setResult(WSHelper.makeResultUnknownError(w.getMessage()));
            return response;
        }
        catch (DispatcherException w) {
            logger.error(w.getMessage(), w);
            response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#incorrectParameter", w.getMessage()));
            return response;
        }
        catch (PAOSException w) {
            logger.error(w.getMessage(), w);
            Throwable innerException = w.getCause();
            if (innerException instanceof WSHelper.WSException) {
                response.setResult(((WSHelper.WSException)innerException).getResult());
            } else {
                response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#incorrectParameter", w.getMessage()));
            }
            return response;
        }
    }

    private TCTokenResponse determineRefreshURL(TCTokenRequest request, TCTokenResponse response) throws IOException {
        Object objectActivation;
        DynamicContext dynCtx = DynamicContext.getInstance("tr03112");
        URL endpoint = response.getRefreshAddress();
        Pair<String, List<Pair<URL, Certificate>>> result = TCTokenGrabber.getResource(endpoint);
        List resultPoints = (List)result.p2;
        Pair last = (Pair)resultPoints.get(resultPoints.size() - 1);
        boolean redirectChecks = ObjectTag.isPerformTR03112Checks(request);
        if (redirectChecks) {
            CertificateDescription desc = null;
            Promise<Object> descPromise = dynCtx.getPromise("eservice_certificate_description");
            try {
                desc = (CertificateDescription)descPromise.deref(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                String msg = "Couldn't retrieve the CertificateDescription from the DynamicContext.";
                logger.error(msg);
                throw new IOException(msg);
            }
            catch (TimeoutException ex) {
                String msg = "Couldn't retrieve the CertificateDescription from the DynamicContext.";
                logger.error(msg);
                throw new IOException(msg);
            }
            for (Pair next : resultPoints) {
                Certificate c = (Certificate)next.p2;
                if (TR03112Utils.isInCommCertificates(c, desc.getCommCertificates())) continue;
                logger.error("The retrieved server certificate is NOT contained in the CommCertificates of the CertificateDescription extension of the eService certificate.");
                throw new ControlException(this.lang.translationForKey("invalid_redirect", new Object[0]));
            }
            URL subjectUrl = new URL(desc.getSubjectURL());
            boolean SOP = TR03112Utils.checkSameOriginPolicy((URL)last.p1, subjectUrl);
            if (!SOP) {
                logger.error("The final redirect of the TCToken does not conform to the same origin policy.");
                throw new ControlException(this.lang.translationForKey("invalid_redirect", new Object[0]));
            }
            endpoint = (URL)last.p1;
        }
        if ((objectActivation = dynCtx.get("object_activation")) instanceof Boolean && !((Boolean)objectActivation).booleanValue()) {
            dynCtx.clear();
            DynamicContext.remove();
        }
        logger.debug("Setting redirect address to '{}'.", (Object)endpoint);
        response.setRefreshAddress(endpoint);
        return response;
    }
}

