/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.plugins.pinplugin.gui;

import org.openecard.common.I18n;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.definition.Step;
import org.openecard.gui.definition.Text;
import org.openecard.plugins.pinplugin.RecognizedState;

public class CANEntryStep
extends Step {
    private final I18n lang = I18n.getTranslation("pinplugin");
    private static final String CANSTEP_NOTICE = "action.changepin.userconsent.canstep.notice";
    private static final String CANSTEP_CAN = "action.changepin.userconsent.canstep.can";
    private static final String CANSTEP_DESCRIPTION = "action.changepin.userconsent.canstep.description";
    private static final String CANSTEP_NATIVE_DESCRIPTION = "action.changepin.userconsent.canstep.native_description";
    private static final String WRONG_CAN = "action.changepin.userconsent.canstepaction.wrong_can";
    private static final String INCORRECT_INPUT = "action.changepin.userconsent.canstepaction.incorrect_input";
    public static final String CAN_FIELD = "CAN_FIELD";

    public CANEntryStep(String id, String title, boolean capturePin, RecognizedState state, boolean enteredWrong, boolean verifyFailed) {
        super(id, title);
        Text i1 = new Text();
        i1.setText(this.lang.translationForKey(CANSTEP_NOTICE, new Object[0]));
        this.getInputInfoUnits().add(i1);
        Text i2 = new Text();
        this.getInputInfoUnits().add(i2);
        if (!capturePin) {
            this.setInstantReturn(true);
            i2.setText(this.lang.translationForKey(CANSTEP_NATIVE_DESCRIPTION, new Object[0]));
        } else {
            i2.setText(this.lang.translationForKey(CANSTEP_DESCRIPTION, new Object[0]));
            PasswordField canField = new PasswordField(CAN_FIELD);
            canField.setDescription(this.lang.translationForKey(CANSTEP_CAN, new Object[0]));
            this.getInputInfoUnits().add(canField);
        }
        if (!state.equals((Object)RecognizedState.PIN_suspended)) {
            this.setInstantReturn(true);
        }
        if (enteredWrong) {
            Text retryText = new Text();
            retryText.setText(this.lang.translationForKey(WRONG_CAN, new Object[0]));
            this.getInputInfoUnits().add(retryText);
        }
        if (verifyFailed) {
            Text incorrectInput = new Text();
            incorrectInput.setText(this.lang.translationForKey(INCORRECT_INPUT, new Object[0]));
            this.getInputInfoUnits().add(incorrectInput);
        }
    }
}

