/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.sal;

import iso.std.iso_iec._24727.tech.schema.CardApplicationConnect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationConnectResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPath;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPathResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPathType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticate;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticateResponse;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import iso.std.iso_iec._24727.tech.schema.DIDGet;
import iso.std.iso_iec._24727.tech.schema.DIDGetResponse;
import iso.std.iso_iec._24727.tech.schema.DIDScopeType;
import iso.std.iso_iec._24727.tech.schema.DIDStructureType;
import iso.std.iso_iec._24727.tech.schema.DSIRead;
import iso.std.iso_iec._24727.tech.schema.DSIReadResponse;
import iso.std.iso_iec._24727.tech.schema.Sign;
import iso.std.iso_iec._24727.tech.schema.SignResponse;
import iso.std.iso_iec._24727.tech.schema.TargetNameType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.openecard.bouncycastle.crypto.tls.Certificate;
import org.openecard.common.SecurityConditionUnsatisfiable;
import org.openecard.common.WSHelper;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.interfaces.DispatcherException;
import org.openecard.crypto.common.sal.ACLResolver;
import org.openecard.crypto.common.sal.CredentialPermissionDenied;
import org.openecard.crypto.common.sal.CryptoMarkerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericCryptoSigner {
    private static final Logger logger = LoggerFactory.getLogger(GenericCryptoSigner.class);
    private final Dispatcher dispatcher;
    private final ConnectionHandleType handle;
    private final String didName;
    private byte[] rawCertData;
    private Map<String, java.security.cert.Certificate[]> javaCerts;
    private Certificate bcCert;

    public GenericCryptoSigner(@Nonnull Dispatcher dispatcher, @Nonnull ConnectionHandleType handle, @Nonnull String didName) {
        this.dispatcher = dispatcher;
        this.handle = handle;
        this.didName = didName;
        this.javaCerts = new HashMap<String, java.security.cert.Certificate[]>();
    }

    public synchronized byte[] getCertificateChain() throws CredentialPermissionDenied, IOException {
        if (this.rawCertData == null) {
            String dataSetName = this.getCertificateDataSetName();
            if (dataSetName == null) {
                throw new IOException("Could not get the certificate data set name.");
            }
            this.rawCertData = this.readCertificateDataset(this.handle, dataSetName);
            if (this.rawCertData == null) {
                throw new IOException("Failed to read certificate contents.");
            }
        }
        return this.rawCertData;
    }

    public java.security.cert.Certificate[] getJavaSecCertificateChain() throws CredentialPermissionDenied, CertificateException, IOException {
        return this.getJavaSecCertificateChain("X.509");
    }

    @Nonnull
    public java.security.cert.Certificate[] getJavaSecCertificateChain(@Nonnull String certType) throws CredentialPermissionDenied, CertificateException, IOException {
        if (!this.javaCerts.containsKey(certType)) {
            byte[] certs = this.getCertificateChain();
            CertificateFactory cf = CertificateFactory.getInstance(certType);
            Collection<? extends java.security.cert.Certificate> javaCert = cf.generateCertificates(new ByteArrayInputStream(certs));
            this.javaCerts.put(certType, javaCert.toArray(new java.security.cert.Certificate[javaCert.size()]));
        }
        return this.javaCerts.get(certType);
    }

    @Nonnull
    public Certificate getBCCertificateChain() throws CredentialPermissionDenied, CertificateException, IOException {
        if (this.bcCert == null) {
            byte[] certs = this.getCertificateChain();
            this.bcCert = this.convertToCertificate(certs);
        }
        return this.bcCert;
    }

    public byte[] sign(@Nonnull byte[] hash) throws SignatureException, CredentialPermissionDenied {
        try {
            this.connectApplication();
            TargetNameType target = new TargetNameType();
            target.setDIDName(this.didName);
            this.performMissingAuthentication(target);
            Sign sign = new Sign();
            sign.setMessage(hash);
            sign.setDIDName(this.didName);
            sign.setDIDScope(DIDScopeType.LOCAL);
            sign.setConnectionHandle(this.handle);
            SignResponse res = (SignResponse)this.dispatcher.deliver(sign);
            WSHelper.checkResult(res);
            return res.getSignature();
        }
        catch (InvocationTargetException e) {
            logger.error("Signature generation failed.", e);
            throw new SignatureException(e);
        }
        catch (DispatcherException e) {
            logger.error("Signature generation failed.", e);
            throw new SignatureException(e);
        }
        catch (WSHelper.WSException e) {
            logger.error("Signature generation failed.", e);
            throw new SignatureException(e);
        }
        catch (SecurityConditionUnsatisfiable e) {
            logger.error("Signature generation failed.", e);
            throw new CredentialPermissionDenied(e);
        }
    }

    private Certificate convertToCertificate(byte[] certificateBytes) throws CertificateException {
        org.openecard.bouncycastle.asn1.x509.Certificate x509Certificate = org.openecard.bouncycastle.asn1.x509.Certificate.getInstance(certificateBytes);
        if (x509Certificate == null) {
            throw new CertificateException("Couldn't convert to x509Certificate.");
        }
        org.openecard.bouncycastle.asn1.x509.Certificate[] certs = new org.openecard.bouncycastle.asn1.x509.Certificate[]{x509Certificate};
        Certificate cert = new Certificate(certs);
        return cert;
    }

    private byte[] readCertificateDataset(ConnectionHandleType cHandle, String dsiName) throws CredentialPermissionDenied {
        byte[] content = null;
        try {
            this.connectApplication();
            TargetNameType target = new TargetNameType();
            target.setDataSetName(dsiName);
            this.performMissingAuthentication(target);
            DSIRead dsiRead = new DSIRead();
            dsiRead.setConnectionHandle(cHandle);
            dsiRead.getConnectionHandle().setCardApplication(cHandle.getCardApplication());
            dsiRead.setDSIName(dsiName);
            DSIReadResponse dsiReadResponse = (DSIReadResponse)this.dispatcher.deliver(dsiRead);
            WSHelper.checkResult(dsiReadResponse);
            content = dsiReadResponse.getDSIContent();
        }
        catch (WSHelper.WSException e) {
            logger.error("Failed to read certificate data set for DSI: {}.", (Object)dsiName, (Object)e);
        }
        catch (InvocationTargetException e) {
            logger.error("Failed to read certificate data set for DSI: {}.", (Object)dsiName, (Object)e);
        }
        catch (DispatcherException e) {
            logger.error("Failed to read certificate data set for DSI: {}.", (Object)dsiName, (Object)e);
        }
        catch (SecurityConditionUnsatisfiable e) {
            logger.error("Failed to read certificate data set for DSI: {}.", (Object)dsiName, (Object)e);
            throw new CredentialPermissionDenied(e);
        }
        return content;
    }

    private String getCertificateDataSetName() {
        String dataSetName = null;
        try {
            DIDGet didGet = new DIDGet();
            didGet.setConnectionHandle(this.handle);
            didGet.setDIDName(this.didName);
            didGet.setDIDScope(DIDScopeType.LOCAL);
            DIDGetResponse response = (DIDGetResponse)this.dispatcher.deliver(didGet);
            CryptoMarkerType cryptoMarker = new CryptoMarkerType(response.getDIDStructure().getDIDMarker());
            dataSetName = cryptoMarker.getCertificateRef().getDataSetName();
        }
        catch (DispatcherException e) {
            logger.error("Failed to get DataSetName for DID: {}.", (Object)this.didName, (Object)e);
        }
        catch (InvocationTargetException e) {
            logger.error("Failed to get DataSetName for DID: {}.", (Object)this.didName, (Object)e);
        }
        catch (NullPointerException e) {
            logger.error("Failed to get DataSetName for DID: {}.", (Object)this.didName, (Object)e);
        }
        return dataSetName;
    }

    private ConnectionHandleType connectApplication() throws DispatcherException, InvocationTargetException, WSHelper.WSException {
        boolean connected = false;
        CardApplicationPath pathReq = new CardApplicationPath();
        CardApplicationPathType pathType = new CardApplicationPathType();
        pathReq.setCardAppPathRequest(pathType);
        pathType.setChannelHandle(this.handle.getChannelHandle());
        pathType.setContextHandle(this.handle.getContextHandle());
        pathType.setIFDName(this.handle.getIFDName());
        pathType.setCardApplication(this.handle.getCardApplication());
        CardApplicationPathResponse pathRes = (CardApplicationPathResponse)this.dispatcher.deliver(pathReq);
        WSHelper.checkResult(pathRes);
        List<CardApplicationPathType> paths = pathRes.getCardAppPathResultSet().getCardApplicationPathResult();
        if (!paths.isEmpty()) {
            connected = true;
        }
        if (!connected) {
            CardApplicationConnect req = new CardApplicationConnect();
            req.setCardApplicationPath(this.handle);
            CardApplicationConnectResponse res = (CardApplicationConnectResponse)this.dispatcher.deliver(req);
            WSHelper.checkResult(res);
            return res.getConnectionHandle();
        }
        return this.handle;
    }

    private void performMissingAuthentication(TargetNameType target) throws DispatcherException, WSHelper.WSException, InvocationTargetException, SecurityConditionUnsatisfiable {
        ACLResolver resolver = new ACLResolver(this.dispatcher, this.handle);
        List<DIDStructureType> missingDIDs = resolver.getUnsatisfiedDIDs(target);
        for (DIDStructureType did : missingDIDs) {
            DIDAuthenticate req = new DIDAuthenticate();
            req.setConnectionHandle(this.handle);
            req.setDIDName(did.getDIDName());
            req.setDIDScope(did.getDIDScope());
            DIDAuthenticationDataType authData = new DIDAuthenticationDataType();
            authData.setProtocol(did.getDIDMarker().getProtocol());
            req.setAuthenticationProtocolData(authData);
            DIDAuthenticateResponse res = (DIDAuthenticateResponse)this.dispatcher.deliver(req);
            WSHelper.checkResult(res);
        }
    }
}

