/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.sal;

import iso.std.iso_iec._24727.tech.schema.ACLList;
import iso.std.iso_iec._24727.tech.schema.ACLListResponse;
import iso.std.iso_iec._24727.tech.schema.AccessRuleType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.CryptographicServiceActionName;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationStateType;
import iso.std.iso_iec._24727.tech.schema.DIDGet;
import iso.std.iso_iec._24727.tech.schema.DIDGetResponse;
import iso.std.iso_iec._24727.tech.schema.DIDScopeType;
import iso.std.iso_iec._24727.tech.schema.DIDStructureType;
import iso.std.iso_iec._24727.tech.schema.NamedDataServiceActionName;
import iso.std.iso_iec._24727.tech.schema.SecurityConditionType;
import iso.std.iso_iec._24727.tech.schema.TargetNameType;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.openecard.common.SecurityConditionUnsatisfiable;
import org.openecard.common.WSHelper;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.interfaces.DispatcherException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLResolver {
    private static final Logger logger = LoggerFactory.getLogger(ACLResolver.class);
    private final Dispatcher dispatcher;
    private final ConnectionHandleType handle;

    public ACLResolver(Dispatcher dispatcher, ConnectionHandleType handle) {
        this.dispatcher = dispatcher;
        this.handle = WSHelper.copyHandle(handle);
    }

    public List<DIDStructureType> getUnsatisfiedDIDs(TargetNameType target) throws DispatcherException, WSHelper.WSException, InvocationTargetException, SecurityConditionUnsatisfiable {
        ACLList aclReq = new ACLList();
        aclReq.setConnectionHandle(this.handle);
        aclReq.setTargetName(target);
        ACLListResponse aclRes = (ACLListResponse)this.dispatcher.deliver(aclReq);
        WSHelper.checkResult(aclRes);
        List<AccessRuleType> acls = aclRes.getTargetACL().getAccessRule();
        List<DIDStructureType> dids = this.getMissingDids(acls, target);
        return dids;
    }

    private List<DIDStructureType> getMissingDids(List<AccessRuleType> acls, TargetNameType target) throws DispatcherException, InvocationTargetException, SecurityConditionUnsatisfiable, WSHelper.WSException {
        ArrayList<AccessRuleType> tmpAcls = new ArrayList<AccessRuleType>();
        for (AccessRuleType next : acls) {
            Enum action;
            if (target.getDIDName() != null && CryptographicServiceActionName.SIGN.equals(action = next.getAction().getCryptographicServiceAction())) {
                tmpAcls.add(next);
                break;
            }
            if (target.getDataSetName() == null) continue;
            action = next.getAction().getNamedDataServiceAction();
            if (NamedDataServiceActionName.DATA_SET_SELECT.equals(action)) {
                tmpAcls.add(next);
                continue;
            }
            if (!NamedDataServiceActionName.DSI_READ.equals(action)) continue;
            tmpAcls.add(next);
        }
        ArrayList<DIDStructureType> result = new ArrayList<DIDStructureType>();
        for (AccessRuleType acl : tmpAcls) {
            SecurityConditionType cond = ACLResolver.normalize(acl.getSecurityCondition());
            cond = ACLResolver.getBestSecurityCondition(cond);
            List<DIDAuthenticationStateType> authStates = ACLResolver.flattenCondition(cond);
            List<DIDStructureType> missingDIDs = this.filterSatisfiedDIDs(authStates);
            result.addAll(missingDIDs);
        }
        TreeSet<String> newDids = new TreeSet<String>();
        Iterator it = result.iterator();
        while (it.hasNext()) {
            DIDStructureType next = (DIDStructureType)it.next();
            if (newDids.contains(next.getDIDName())) {
                it.remove();
                continue;
            }
            newDids.add(next.getDIDName());
        }
        return result;
    }

    private static SecurityConditionType normalize(SecurityConditionType cond) {
        if (cond.getOr() == null) {
            SecurityConditionType result = new SecurityConditionType();
            SecurityConditionType.Or or = new SecurityConditionType.Or();
            result.setOr(or);
            or.getSecurityCondition().add(cond);
            return result;
        }
        return cond;
    }

    private static SecurityConditionType getBestSecurityCondition(SecurityConditionType securityCondition) {
        return securityCondition.getOr().getSecurityCondition().get(0);
    }

    private static List<DIDAuthenticationStateType> flattenCondition(SecurityConditionType conds) throws SecurityConditionUnsatisfiable {
        if (conds.getAnd() != null) {
            ArrayList<DIDAuthenticationStateType> result = new ArrayList<DIDAuthenticationStateType>();
            for (SecurityConditionType cond : conds.getAnd().getSecurityCondition()) {
                DIDAuthenticationStateType state = cond.getDIDAuthentication();
                if (state == null) continue;
                result.add(cond.getDIDAuthentication());
            }
            return result;
        }
        if (conds.getDIDAuthentication() != null) {
            ArrayList<DIDAuthenticationStateType> result = new ArrayList<DIDAuthenticationStateType>();
            result.add(conds.getDIDAuthentication());
            return result;
        }
        if (conds.isAlways() != null && conds.isAlways().booleanValue()) {
            return Collections.emptyList();
        }
        if (conds.isNever() != null && conds.isNever().booleanValue()) {
            String msg = "The ACL of the object states, that it is never satisfiable (never=true).";
            throw new SecurityConditionUnsatisfiable(msg);
        }
        return Collections.emptyList();
    }

    private List<DIDStructureType> filterSatisfiedDIDs(List<DIDAuthenticationStateType> states) throws DispatcherException, InvocationTargetException, WSHelper.WSException {
        ArrayList<DIDStructureType> result = new ArrayList<DIDStructureType>(states.size());
        for (DIDAuthenticationStateType state : states) {
            if (!state.isDIDState()) continue;
            DIDGet req = new DIDGet();
            req.setConnectionHandle(this.handle);
            req.setDIDName(state.getDIDName());
            req.setDIDScope(DIDScopeType.GLOBAL);
            DIDGetResponse res = (DIDGetResponse)this.dispatcher.deliver(req);
            WSHelper.checkResult(res);
            if (res.getDIDStructure().isAuthenticated()) continue;
            result.add(res.getDIDStructure());
        }
        return result;
    }
}

