/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.module.tctoken;

import generated.TCTokenType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import org.openecard.bouncycastle.crypto.tls.ProtocolVersion;
import org.openecard.bouncycastle.crypto.tls.TlsClient;
import org.openecard.bouncycastle.crypto.tls.TlsClientProtocol;
import org.openecard.bouncycastle.crypto.tls.TlsPSKIdentity;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.control.module.tctoken.ConnectionError;
import org.openecard.control.module.tctoken.TCTokenRequest;
import org.openecard.crypto.common.sal.GenericCryptoSignerFinder;
import org.openecard.crypto.tls.ClientCertDefaultTlsClient;
import org.openecard.crypto.tls.ClientCertPSKTlsClient;
import org.openecard.crypto.tls.ClientCertTlsClient;
import org.openecard.crypto.tls.TlsPSKIdentityImpl;
import org.openecard.crypto.tls.auth.CredentialFactory;
import org.openecard.crypto.tls.auth.DynamicAuthentication;
import org.openecard.crypto.tls.auth.SmartCardCredentialFactory;
import org.openecard.crypto.tls.proxy.ProxySettings;

public class TlsConnectionHandler {
    private final Dispatcher dispatcher;
    private final TCTokenRequest tokenRequest;
    private final ConnectionHandleType handle;
    private URL serverAddress;
    private String hostname;
    private int port;
    private String resource;
    private String sessionId;
    private ClientCertTlsClient tlsClient;
    private boolean usesTls = false;

    public TlsConnectionHandler(Dispatcher dispatcher, TCTokenRequest tokenRequest, ConnectionHandleType handle) throws ConnectionError {
        this.dispatcher = dispatcher;
        this.tokenRequest = tokenRequest;
        this.handle = handle;
    }

    public void setUpClient() throws ConnectionError {
        block8: {
            try {
                TCTokenType token = this.tokenRequest.getTCToken();
                String cardType = null;
                if (this.handle.getRecognitionInfo() != null) {
                    cardType = this.handle.getRecognitionInfo().getCardType();
                }
                if (cardType == null) {
                    cardType = this.tokenRequest.getCardType();
                }
                boolean noSni = "http://bsi.bund.de/cif/npa.xml".equals(cardType);
                this.sessionId = token.getSessionIdentifier();
                this.serverAddress = new URL(token.getServerAddress());
                String serverHost = this.serverAddress.getHost();
                String secProto = token.getPathSecurityProtocol();
                this.serverAddress = TlsConnectionHandler.fixServerAddress(this.serverAddress, this.sessionId);
                this.hostname = this.serverAddress.getHost();
                this.port = this.serverAddress.getPort();
                if (this.port == -1) {
                    this.port = this.serverAddress.getDefaultPort();
                }
                this.resource = this.serverAddress.getFile();
                if (this.serverAddress.getProtocol().equals("http")) {
                    this.usesTls = false;
                    return;
                }
                this.usesTls = true;
                if (secProto.equals("urn:ietf:rfc:4279") || secProto.equals("urn:ietf:rfc:5487")) {
                    DynamicAuthentication tlsAuth = new DynamicAuthentication();
                    tlsAuth.setHostname(serverHost);
                    byte[] psk = token.getPathSecurityParameters().getPSK();
                    TlsPSKIdentityImpl pskId = new TlsPSKIdentityImpl(this.sessionId.getBytes(), psk);
                    this.tlsClient = new ClientCertPSKTlsClient((TlsPSKIdentity)pskId, noSni ? null : serverHost);
                    this.tlsClient.setAuthentication(tlsAuth);
                    this.tlsClient.setClientVersion(ProtocolVersion.TLSv11);
                    break block8;
                }
                if (secProto.equals("urn:ietf:rfc:4346")) {
                    DynamicAuthentication tlsAuth = new DynamicAuthentication();
                    tlsAuth.setHostname(serverHost);
                    tlsAuth.setCredentialFactory(this.makeSmartCardCredential());
                    this.tlsClient = new ClientCertDefaultTlsClient(noSni ? null : serverHost);
                    this.tlsClient.setAuthentication(tlsAuth);
                    this.tlsClient.setClientVersion(ProtocolVersion.TLSv11);
                    break block8;
                }
                throw new ConnectionError("Unknow security protocol '" + secProto + "' requested.");
            }
            catch (MalformedURLException ex) {
                throw new ConnectionError(ex);
            }
        }
    }

    public boolean usesTls() {
        return this.usesTls;
    }

    public URL getServerAddress() {
        return this.serverAddress;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getResource() {
        return this.resource;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public TlsClient getTlsClient() {
        return this.tlsClient;
    }

    public TlsClientProtocol createTlsConnection(ProtocolVersion tlsVersion) throws IOException, URISyntaxException {
        Socket socket = ProxySettings.getDefault().getSocket(this.hostname, this.port);
        this.tlsClient.setClientVersion(tlsVersion);
        InputStream sockIn = socket.getInputStream();
        OutputStream sockOut = socket.getOutputStream();
        TlsClientProtocol handler = new TlsClientProtocol(sockIn, sockOut);
        handler.connect(this.tlsClient);
        return handler;
    }

    private static URL fixServerAddress(URL serverAddress, String sessionIdentifier) throws MalformedURLException {
        URL realServerAddress = serverAddress;
        String queryPart = serverAddress.getQuery();
        if (queryPart == null || !queryPart.contains("?sessionid=") && !queryPart.contains("&sessionid=")) {
            String sAddr = serverAddress.toString();
            if (serverAddress.getPath().isEmpty()) {
                sAddr = sAddr + "/";
            }
            sAddr = sAddr.endsWith("?") ? sAddr + "sessionid=" + sessionIdentifier : (sAddr.contains("?") ? sAddr + "&sessionid=" + sessionIdentifier : sAddr + "?sessionid=" + sessionIdentifier);
            realServerAddress = new URL(sAddr);
        }
        return realServerAddress;
    }

    private CredentialFactory makeSmartCardCredential() {
        GenericCryptoSignerFinder finder = new GenericCryptoSignerFinder(this.dispatcher, this.handle, false);
        SmartCardCredentialFactory scFac = new SmartCardCredentialFactory(finder);
        return scFac;
    }
}

