/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.module.status;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Map;
import org.openecard.addon.EventHandler;
import org.openecard.common.util.HttpRequestLineUtils;
import org.openecard.control.module.status.StatusChangeRequest;
import org.openecard.control.module.status.StatusHandler;
import org.openecard.ws.schema.StatusChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitForChangeHandler {
    private static final Logger logger = LoggerFactory.getLogger(StatusHandler.class);
    private final EventHandler eventHandler;

    public WaitForChangeHandler(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public StatusChange getStatusChange(StatusChangeRequest statusRequest) {
        return this.eventHandler.next(statusRequest.getSessionIdentifier());
    }

    public StatusChangeRequest parseStatusChangeRequestURI(URI requestURI) throws UnsupportedEncodingException, MalformedURLException {
        Map<String, String> queries = HttpRequestLineUtils.transform(requestURI.getRawQuery());
        String sessionIdentfier = null;
        for (Map.Entry<String, String> next : queries.entrySet()) {
            String name = next.getKey();
            String value = next.getValue();
            if (name.startsWith("session")) {
                if (value != null && !value.isEmpty()) {
                    sessionIdentfier = value;
                    continue;
                }
                throw new IllegalArgumentException("Malformed StatusURL");
            }
            logger.debug("Unknown query element: {}", (Object)name);
        }
        if (sessionIdentfier == null) {
            throw new MalformedURLException("RequestURI is missing mandatory session parameter.");
        }
        return new StatusChangeRequest(sessionIdentfier);
    }
}

