/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.module.status;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.openecard.addon.AddonManager;
import org.openecard.addon.AddonRegistry;
import org.openecard.addon.Context;
import org.openecard.addon.EventHandler;
import org.openecard.addon.bind.AppPluginAction;
import org.openecard.addon.bind.Attachment;
import org.openecard.addon.bind.BindingResult;
import org.openecard.addon.bind.BindingResultCode;
import org.openecard.addon.bind.Body;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.addon.manifest.ProtocolPluginSpecification;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.control.module.status.StatusException;
import org.openecard.control.module.status.StatusHandler;
import org.openecard.control.module.status.StatusRequest;
import org.openecard.recognition.CardRecognition;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.openecard.ws.marshal.WSMarshallerFactory;
import org.openecard.ws.schema.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class StatusAction
implements AppPluginAction {
    private static final Logger logger = LoggerFactory.getLogger(StatusAction.class);
    private StatusHandler statusHandler;
    private WSMarshaller m;

    @Override
    public void init(Context ctx) {
        try {
            this.m = WSMarshallerFactory.createInstance();
            this.m.removeAllTypeClasses();
            this.m.addXmlTypeClass(Status.class);
        }
        catch (WSMarshallerException e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        CardRecognition rec = ctx.getRecognition();
        List<String> protocolInfo = this.getProtocolInfo(ctx.getManager());
        CardStateMap cardStates = ctx.getCardStates();
        EventHandler eventHandler = ctx.getEventHandler();
        this.statusHandler = new StatusHandler(cardStates, eventHandler, protocolInfo, rec);
    }

    @Override
    public void destroy() {
    }

    @Override
    public BindingResult execute(Body body, Map<String, String> parameters, List<Attachment> attachments) {
        BindingResult response;
        try {
            StatusRequest statusRequest = this.checkParameters(parameters);
            Status statusResponse = this.statusHandler.handleRequest(statusRequest);
            response = this.handleResponse(statusResponse);
        }
        catch (StatusException e) {
            response = new BindingResult(BindingResultCode.WRONG_PARAMETER);
            response.setResultMessage(e.getMessage());
        }
        catch (Exception e) {
            response = new BindingResult(BindingResultCode.INTERNAL_ERROR);
            logger.error(e.getMessage(), e);
        }
        return response;
    }

    private StatusRequest checkParameters(Map<String, String> parameters) throws StatusException {
        StatusRequest statusRequest = new StatusRequest();
        if (parameters.containsKey("session")) {
            String value = parameters.get("session");
            if (value != null && !value.isEmpty()) {
                statusRequest.setSessionIdentifier(value);
            } else {
                throw new StatusException("Value for session parameter is missing.");
            }
        }
        for (String s : parameters.keySet()) {
            if (s.equals("session")) continue;
            logger.debug("Unknown query element: {}", (Object)s);
        }
        return statusRequest;
    }

    private BindingResult handleResponse(Status response) throws Exception {
        BindingResult httpResponse = new BindingResult(BindingResultCode.OK);
        Document xml = this.m.marshal(response);
        Body body = new Body(xml, "text/xml");
        httpResponse.setBody(body);
        return httpResponse;
    }

    private List<String> getProtocolInfo(AddonManager manager) {
        TreeSet<String> result = new TreeSet<String>();
        AddonRegistry registry = manager.getRegistry();
        Set<AddonSpecification> addons = registry.listPlugins();
        for (AddonSpecification addon : addons) {
            for (ProtocolPluginSpecification proto : addon.getSalActions()) {
                result.add(proto.getUri());
            }
        }
        return new ArrayList<String>(result);
    }
}

