/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import java.io.IOException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.openecard.bouncycastle.crypto.tls.Certificate;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.util.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TR03112Utils {
    private static final Logger logger = LoggerFactory.getLogger(TR03112Utils.class.getName());
    private static final int TAG_OCTET_STRING = 4;
    private static final String SHA256 = "SHA-256";

    public static boolean checkSameOriginPolicy(URL url1, URL url2) {
        int subjectPort;
        String subjectHost;
        logger.debug("Checking SOP for {} and {}.", (Object)url1, (Object)url2);
        String endpointProtocol = url1.getProtocol();
        String subjectProtocol = url2.getProtocol();
        if (!endpointProtocol.equals(subjectProtocol)) {
            logger.error("SOP violated; the protocols do not match.");
            return false;
        }
        String endpointHost = url1.getHost();
        if (!endpointHost.equals(subjectHost = url2.getHost())) {
            logger.error("SOP violated; the hosts do not match.");
            return false;
        }
        int endpointPort = url1.getPort();
        if (endpointPort == -1) {
            endpointPort = url1.getDefaultPort();
        }
        if ((subjectPort = url2.getPort()) == -1) {
            subjectPort = url2.getDefaultPort();
        }
        if (endpointPort != subjectPort) {
            logger.error("SOP violated; the ports do not match");
            return false;
        }
        return true;
    }

    public static boolean isInCommCertificates(Certificate serverCertificate, List<byte[]> commCertificates) {
        try {
            MessageDigest md = MessageDigest.getInstance(SHA256);
            md.update(serverCertificate.getCertificateAt(0).getEncoded());
            byte[] hash = md.digest();
            TLV tlv = new TLV();
            tlv.setTagNumWithClass(4L);
            tlv.setValue(hash);
            byte[] hashTag = tlv.toBER();
            if (logger.isDebugEnabled()) {
                logger.debug("Hash (with tag) of the retrieved server certificate: {}", (Object)ByteUtils.toHexString(hashTag));
            }
            for (byte[] commCertificate : commCertificates) {
                logger.debug("CommCertificate: {}", (Object)ByteUtils.toHexString(commCertificate));
                if (!ByteUtils.compare(commCertificate, hashTag)) continue;
                return true;
            }
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("SHA-256 digest algorithm is not available.");
            return false;
        }
        catch (TLVException e) {
            logger.error("TLV construction failed.");
            return false;
        }
        catch (IOException e) {
            logger.error("Server certificate couldn't be encoded.");
            return false;
        }
        return false;
    }

    public static boolean isRedirectStatusCode(int statusCode) {
        switch (statusCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                return true;
            }
        }
        return false;
    }
}

