/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.util.IntegerUtils;

class TagLengthValue {
    private int numOctets;
    private Tag tag;
    private byte[] value;

    private TagLengthValue(int numOctets, Tag tag, byte[] value) {
        this.numOctets = numOctets;
        this.tag = tag;
        this.value = value;
    }

    private TagLengthValue(int numOctets, TagClass tagClass, boolean primitive, long tagNum, byte[] value) {
        this(numOctets, new Tag(tagClass, primitive, tagNum), value);
    }

    private TagLengthValue(Tag tag, byte[] value) {
        this(0, tag, value);
    }

    public TagLengthValue(TagClass tagClass, boolean primitive, long tagNum, byte[] value) {
        this(0, tagClass, primitive, tagNum, value);
    }

    public TagLengthValue() {
        this(0, new Tag(), new byte[0]);
    }

    public TagClass getTagClass() {
        return this.tag.getTagClass();
    }

    public void setTagClass(TagClass tagClass) {
        this.tag.setTagClass(tagClass);
    }

    public boolean isPrimitive() {
        return this.tag.isPrimitive();
    }

    void setPrimitive(boolean primitive) {
        this.tag.setPrimitive(primitive);
    }

    public long getTagNum() {
        return this.tag.getTagNum();
    }

    public void setTagNum(long tagNum) {
        this.tag.setTagNum(tagNum);
    }

    public long getTagNumWithClass() {
        return this.tag.getTagNumWithClass();
    }

    public void setTagNumWithClass(long tagNumWithClass) throws TLVException {
        this.tag.setTagNumWithClass(tagNumWithClass);
    }

    public int getValueLength() {
        return this.value.length;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    int getRawLength() {
        return this.numOctets;
    }

    byte[] extractRest(byte[] inputWithThisTag) {
        return Arrays.copyOfRange(inputWithThisTag, this.getRawLength(), inputWithThisTag.length);
    }

    static TagLengthValue fromBER(byte[] data) throws TLVException {
        Tag tag = Tag.fromBER(data);
        int numOctets = tag.numOctets;
        int dataLength = 0;
        boolean endOfLine = false;
        if ((data[numOctets] >> 7 & 1) == 0) {
            dataLength = data[numOctets];
            ++numOctets;
        } else if ((data[numOctets] & 0x7F) == 0) {
            endOfLine = true;
            ++numOctets;
            int i = 0;
            boolean endFound = false;
            boolean zeroFound = false;
            do {
                if (data.length <= numOctets + i) {
                    throw new TLVException("Not enough bytes in input to read TLV length.");
                }
                byte next = data[numOctets + i];
                if (next == 0) {
                    if (zeroFound) {
                        endFound = true;
                    } else {
                        zeroFound = true;
                    }
                } else {
                    zeroFound = false;
                }
                ++i;
            } while (!endFound);
            dataLength = i - 2;
        } else {
            int i;
            int numLengthBytes = data[numOctets] & 0x7F;
            ++numOctets;
            for (i = 0; i < numLengthBytes; ++i) {
                if (i * 8 > 32) {
                    throw new TLVException("Length doesn't fit into a 32 bit word.");
                }
                if (data.length < numOctets + i + 1) {
                    throw new TLVException("Not enough bytes in input to read TLV length.");
                }
                dataLength = data[numOctets + i] < 0 ? dataLength << 8 | 256 + data[numOctets + i] : dataLength << 8 | data[numOctets + i];
            }
            numOctets += i;
        }
        byte[] dataField = Arrays.copyOfRange(data, numOctets, numOctets + dataLength);
        numOctets += dataLength;
        if (endOfLine) {
            numOctets += 2;
        }
        TagLengthValue result = new TagLengthValue(numOctets, tag, dataField);
        return result;
    }

    byte[] toBER() throws TLVException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] tagBytes = this.tag.toBER();
            out.write(tagBytes);
            int len = this.getValueLength();
            if (len <= 127) {
                out.write((byte)len);
            } else {
                byte[] lenBytes = IntegerUtils.toByteArray(len);
                byte lenHeader = (byte)(0x80 | lenBytes.length);
                out.write(lenHeader);
                out.write(lenBytes);
            }
            out.write(this.getValue());
            return out.toByteArray();
        }
        catch (IOException ex) {
            throw new TLVException(ex);
        }
    }
}

