/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common;

import iso.std.iso_iec._24727.tech.schema.CardApplicationPathType;
import iso.std.iso_iec._24727.tech.schema.ChannelHandleType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.PathSecurityType;
import iso.std.iso_iec._24727.tech.schema.TransmitResponse;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import oasis.names.tc.dss._1_0.core.schema.InternationalStringType;
import oasis.names.tc.dss._1_0.core.schema.ResponseBaseType;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.openecard.common.ECardException;
import org.openecard.common.apdu.common.CardCommandStatus;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.util.ByteUtils;

public class WSHelper {
    public static ResponseBaseType checkResult(ResponseBaseType response) throws WSException {
        Result r = response.getResult();
        if (r.getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error")) {
            if (response instanceof TransmitResponse) {
                TransmitResponse tr = (TransmitResponse)response;
                List<byte[]> rApdus = tr.getOutputAPDU();
                if (rApdus.size() < 1) {
                    throw new WSException(r);
                }
                byte[] apdu = CardResponseAPDU.getTrailer(rApdus.get(rApdus.size() - 1));
                String msg = CardCommandStatus.getMessage(apdu);
                throw new WSException(msg);
            }
            throw new WSException(r);
        }
        return response;
    }

    public static Result makeResultOK() {
        Result result = WSHelper.makeResult("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#ok", null, null, null);
        return result;
    }

    public static Result makeResultUnknownError(String msg) {
        Result result = WSHelper.makeResult("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error", "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#unknownError", msg);
        return result;
    }

    public static Result makeResult(String major, String minor, String message) {
        Result result = WSHelper.makeResult(major, minor, message, "en");
        return result;
    }

    public static Result makeResultError(String minor, String message) {
        Result result = WSHelper.makeResult("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error", minor, message, "en");
        return result;
    }

    public static Result makeResult(Throwable exc) {
        if (exc instanceof ECardException) {
            ECardException e = (ECardException)exc;
            Result result = e.getResult();
            return result;
        }
        Result result = WSHelper.makeResultUnknownError(exc.getMessage());
        return result;
    }

    public static Result makeResult(String major, String minor, String message, String lang) {
        Result r = new Result();
        r.setResultMajor(major);
        r.setResultMinor(minor);
        if (message != null) {
            InternationalStringType msg = new InternationalStringType();
            msg.setValue(message);
            msg.setLang(lang);
            r.setResultMessage(msg);
        }
        return r;
    }

    public static <C extends Class<T>, T extends ResponseBaseType> T makeResponse(C c, Result r) {
        try {
            ResponseBaseType t = (ResponseBaseType)c.getConstructor(new Class[0]).newInstance(new Object[0]);
            t.setProfile("http://www.bsi.bund.de/ecard/api/1.1");
            t.setResult(r);
            return (T)t;
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public static ConnectionHandleType copyHandle(ConnectionHandleType handle) {
        ConnectionHandleType result = new ConnectionHandleType();
        WSHelper.copyPath(result, handle);
        result.setSlotHandle(ByteUtils.clone(handle.getSlotHandle()));
        result.setRecognitionInfo(WSHelper.copyRecognition(handle.getRecognitionInfo()));
        return result;
    }

    public static CardApplicationPathType copyPath(CardApplicationPathType handle) {
        CardApplicationPathType result = new CardApplicationPathType();
        WSHelper.copyPath(result, handle);
        return result;
    }

    private static void copyPath(CardApplicationPathType out, CardApplicationPathType in) {
        out.setCardApplication(ByteUtils.clone(in.getCardApplication()));
        out.setChannelHandle(WSHelper.copyChannel(in.getChannelHandle()));
        out.setContextHandle(ByteUtils.clone(in.getContextHandle()));
        out.setIFDName(in.getIFDName());
        out.setSlotIndex(in.getSlotIndex());
    }

    private static ChannelHandleType copyChannel(ChannelHandleType handle) {
        if (handle == null) {
            return null;
        }
        ChannelHandleType result = new ChannelHandleType();
        result.setBinding(handle.getBinding());
        result.setPathSecurity(WSHelper.copyPathSec(handle.getPathSecurity()));
        result.setProtocolTerminationPoint(handle.getProtocolTerminationPoint());
        result.setSessionIdentifier(handle.getSessionIdentifier());
        return result;
    }

    private static ConnectionHandleType.RecognitionInfo copyRecognition(ConnectionHandleType.RecognitionInfo rec) {
        if (rec == null) {
            return null;
        }
        ConnectionHandleType.RecognitionInfo result = new ConnectionHandleType.RecognitionInfo();
        if (rec.getCaptureTime() != null) {
            result.setCaptureTime((XMLGregorianCalendar)rec.getCaptureTime().clone());
        }
        result.setCardIdentifier(ByteUtils.clone(rec.getCardIdentifier()));
        result.setCardType(rec.getCardType());
        return result;
    }

    private static PathSecurityType copyPathSec(PathSecurityType sec) {
        if (sec == null) {
            return null;
        }
        PathSecurityType result = new PathSecurityType();
        result.setParameters(sec.getParameters());
        result.setProtocol(sec.getProtocol());
        return result;
    }

    public static class WSException
    extends ECardException {
        private static final long serialVersionUID = 1L;

        protected WSException(Result r) {
            WSException.makeException(this, r);
        }

        protected WSException(String msg) {
            WSException.makeException(this, msg);
        }
    }
}

