/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.openecard.common.util.FileUtils;

public class I18n {
    private static final ConcurrentSkipListMap<String, I18n> translations = new ConcurrentSkipListMap();
    private final String component;
    private final Properties translation;
    private final TreeMap<String, URL> translatedFiles;

    public static synchronized I18n getTranslation(String component) {
        if (translations.containsKey(component)) {
            return translations.get(component);
        }
        I18n t = new I18n(component);
        translations.put(component, t);
        return t;
    }

    private I18n(String component) {
        Properties target;
        Locale userLocale = Locale.getDefault();
        String lang = userLocale.getLanguage();
        String country = userLocale.getCountry();
        Properties defaults = I18n.loadFile(component, "C");
        if (!lang.isEmpty()) {
            target = I18n.loadFile(component, lang);
            defaults = I18n.mergeProperties(defaults, target);
        }
        if (!lang.isEmpty() && !country.isEmpty()) {
            target = I18n.loadFile(component, lang + "_" + country);
            defaults = I18n.mergeProperties(defaults, target);
        }
        this.component = component;
        this.translation = defaults;
        this.translatedFiles = new TreeMap();
    }

    private static Properties loadFile(String component, String locale) {
        try {
            String fileName = "/openecard_i18n/" + component + "/Messages_" + locale + ".properties";
            InputStream in = FileUtils.resolveResourceAsStream(I18n.class, fileName);
            Properties props = new Properties();
            InputStreamReader r = new InputStreamReader(in, "utf-8");
            props.load(r);
            return props;
        }
        catch (IOException ex) {
            return new Properties();
        }
        catch (RuntimeException ex) {
            return new Properties();
        }
    }

    private static Properties mergeProperties(Properties defaults, Properties target) {
        Properties result = new Properties(defaults);
        result.putAll((Map<?, ?>)target);
        return result;
    }

    public String associatedComponent() {
        return this.component;
    }

    public String translationForKey(String key, Object ... parameters) {
        String result = this.translation.getProperty(key.toLowerCase());
        if (result == null) {
            return "<<No translation for key <" + key + ">>";
        }
        if (parameters.length != 0) {
            String formattedResult = String.format(result, parameters);
            return formattedResult;
        }
        return result;
    }

    public URL translationForFile(String name) throws IOException {
        return this.translationForFile(name, null);
    }

    public synchronized URL translationForFile(String name, String fileEnding) throws IOException {
        String fileName;
        URL url;
        fileEnding = fileEnding != null ? "." + fileEnding : "";
        String mapKey = name + fileEnding;
        if (this.translatedFiles.containsKey(mapKey)) {
            URL url2 = this.translatedFiles.get(mapKey);
            if (url2 == null) {
                throw new IOException("No translation available for file '" + name + fileEnding + "'.");
            }
            return url2;
        }
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        String fnameBase = "/openecard_i18n/" + this.component + "/" + name;
        if (!lang.isEmpty() && !country.isEmpty() && (url = FileUtils.resolveResourceAsURL(I18n.class, fileName = fnameBase + "_" + lang + "_" + country + fileEnding)) != null) {
            this.translatedFiles.put(mapKey, url);
            return url;
        }
        if (!lang.isEmpty() && (url = FileUtils.resolveResourceAsURL(I18n.class, fileName = fnameBase + "_" + lang + fileEnding)) != null) {
            this.translatedFiles.put(mapKey, url);
            return url;
        }
        fileName = fnameBase + "_C" + fileEnding;
        url = FileUtils.resolveResourceAsURL(I18n.class, fileName);
        if (url != null) {
            this.translatedFiles.put(mapKey, url);
            return url;
        }
        this.translatedFiles.put(mapKey, null);
        throw new IOException("No translation available for file '" + name + fileEnding + "'.");
    }

    static {
        I18n.getTranslation("ifd");
        I18n.getTranslation("sal");
    }
}

