/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.openecard.bouncycastle.crypto.tls.AbstractTlsContext;
import org.openecard.bouncycastle.crypto.tls.ByteQueue;
import org.openecard.bouncycastle.crypto.tls.Certificate;
import org.openecard.bouncycastle.crypto.tls.ProtocolVersion;
import org.openecard.bouncycastle.crypto.tls.RecordStream;
import org.openecard.bouncycastle.crypto.tls.SecurityParameters;
import org.openecard.bouncycastle.crypto.tls.SupplementalDataEntry;
import org.openecard.bouncycastle.crypto.tls.TlsContext;
import org.openecard.bouncycastle.crypto.tls.TlsFatalAlert;
import org.openecard.bouncycastle.crypto.tls.TlsInputStream;
import org.openecard.bouncycastle.crypto.tls.TlsKeyExchange;
import org.openecard.bouncycastle.crypto.tls.TlsOutputStream;
import org.openecard.bouncycastle.crypto.tls.TlsPeer;
import org.openecard.bouncycastle.crypto.tls.TlsUtils;
import org.openecard.bouncycastle.util.Arrays;
import org.openecard.bouncycastle.util.Integers;

public abstract class TlsProtocol {
    protected static final Integer EXT_RenegotiationInfo = Integers.valueOf(65281);
    protected static final Integer EXT_SessionTicket = Integers.valueOf(35);
    private static final String TLS_ERROR_MESSAGE = "Internal TLS error, this could be an attack";
    protected static final short CS_START = 0;
    protected static final short CS_CLIENT_HELLO = 1;
    protected static final short CS_SERVER_HELLO = 2;
    protected static final short CS_SERVER_SUPPLEMENTAL_DATA = 3;
    protected static final short CS_SERVER_CERTIFICATE = 4;
    protected static final short CS_SERVER_KEY_EXCHANGE = 5;
    protected static final short CS_CERTIFICATE_REQUEST = 6;
    protected static final short CS_SERVER_HELLO_DONE = 7;
    protected static final short CS_CLIENT_SUPPLEMENTAL_DATA = 8;
    protected static final short CS_CLIENT_CERTIFICATE = 9;
    protected static final short CS_CLIENT_KEY_EXCHANGE = 10;
    protected static final short CS_CERTIFICATE_VERIFY = 11;
    protected static final short CS_CLIENT_CHANGE_CIPHER_SPEC = 12;
    protected static final short CS_CLIENT_FINISHED = 13;
    protected static final short CS_SERVER_SESSION_TICKET = 14;
    protected static final short CS_SERVER_CHANGE_CIPHER_SPEC = 15;
    protected static final short CS_SERVER_FINISHED = 16;
    private ByteQueue applicationDataQueue = new ByteQueue();
    protected ByteQueue changeCipherSpecQueue = new ByteQueue();
    private ByteQueue alertQueue = new ByteQueue();
    private ByteQueue handshakeQueue = new ByteQueue();
    protected RecordStream recordStream;
    protected SecureRandom secureRandom;
    private TlsInputStream tlsInputStream = null;
    private TlsOutputStream tlsOutputStream = null;
    private volatile boolean closed = false;
    private volatile boolean failedWithError = false;
    private volatile boolean appDataReady = false;
    private volatile boolean writeExtraEmptyRecords = true;
    private byte[] expected_verify_data = null;
    protected byte[] client_verify_data = null;
    protected byte[] server_verify_data = null;
    protected boolean resumed = false;
    protected SecurityParameters securityParameters = null;
    protected short connection_state = 0;
    protected boolean secure_renegotiation = false;
    protected boolean expectSessionTicket = false;

    public TlsProtocol(InputStream input, OutputStream output, SecureRandom secureRandom) {
        this.recordStream = new RecordStream(this, input, output);
        this.secureRandom = secureRandom;
    }

    protected abstract AbstractTlsContext getContext();

    protected abstract TlsPeer getPeer();

    protected abstract void handleChangeCipherSpecMessage() throws IOException;

    protected abstract void handleHandshakeMessage(short var1, byte[] var2) throws IOException;

    protected void handleWarningMessage(short description) throws IOException {
    }

    protected void completeHandshake() throws IOException {
        this.expected_verify_data = null;
        while (this.connection_state != 16) {
            this.safeReadRecord();
        }
        this.recordStream.finaliseHandshake();
        ProtocolVersion version = this.getContext().getServerVersion();
        this.writeExtraEmptyRecords = version.isEqualOrEarlierVersionOf(ProtocolVersion.TLSv10);
        if (!this.appDataReady) {
            this.appDataReady = true;
            this.tlsInputStream = new TlsInputStream(this);
            this.tlsOutputStream = new TlsOutputStream(this);
        }
    }

    protected void processRecord(short protocol, byte[] buf, int offset, int len) throws IOException {
        switch (protocol) {
            case 20: {
                this.changeCipherSpecQueue.addData(buf, offset, len);
                this.processChangeCipherSpec();
                break;
            }
            case 21: {
                this.alertQueue.addData(buf, offset, len);
                this.processAlert();
                break;
            }
            case 22: {
                this.handshakeQueue.addData(buf, offset, len);
                this.processHandshake();
                break;
            }
            case 23: {
                if (!this.appDataReady) {
                    this.failWithError((short)2, (short)10);
                }
                this.applicationDataQueue.addData(buf, offset, len);
                this.processApplicationData();
                break;
            }
        }
    }

    private void processHandshake() throws IOException {
        boolean read;
        do {
            read = false;
            if (this.handshakeQueue.size() < 4) continue;
            byte[] beginning = new byte[4];
            this.handshakeQueue.read(beginning, 0, 4, 0);
            ByteArrayInputStream bis = new ByteArrayInputStream(beginning);
            short type = TlsUtils.readUint8(bis);
            int len = TlsUtils.readUint24(bis);
            if (this.handshakeQueue.size() < len + 4) continue;
            byte[] buf = new byte[len];
            this.handshakeQueue.read(buf, 0, len, 4);
            this.handshakeQueue.removeData(len + 4);
            switch (type) {
                case 0: {
                    break;
                }
                case 20: {
                    if (this.expected_verify_data == null) {
                        this.expected_verify_data = this.createVerifyData(!this.getContext().isServer());
                    }
                }
                default: {
                    this.recordStream.updateHandshakeData(beginning, 0, 4);
                    this.recordStream.updateHandshakeData(buf, 0, len);
                }
            }
            this.handleHandshakeMessage(type, buf);
            read = true;
        } while (read);
    }

    private void processApplicationData() {
    }

    private void processAlert() throws IOException {
        while (this.alertQueue.size() >= 2) {
            byte[] tmp = new byte[2];
            this.alertQueue.read(tmp, 0, 2, 0);
            this.alertQueue.removeData(2);
            short level = tmp[0];
            short description = tmp[1];
            this.getPeer().notifyAlertReceived(level, description);
            if (level == 2) {
                this.failedWithError = true;
                this.closed = true;
                try {
                    this.recordStream.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw new IOException(TLS_ERROR_MESSAGE);
            }
            if (description == 0) {
                this.handleClose(false);
            }
            this.handleWarningMessage(description);
        }
    }

    protected void processChangeCipherSpec() throws IOException {
        while (this.changeCipherSpecQueue.size() > 0) {
            byte[] b = new byte[1];
            this.changeCipherSpecQueue.read(b, 0, 1, 0);
            this.changeCipherSpecQueue.removeData(1);
            if (b[0] != 1) {
                this.failWithError((short)2, (short)10);
            }
            this.recordStream.receivedReadCipherSpec();
            this.handleChangeCipherSpecMessage();
        }
    }

    protected int readApplicationData(byte[] buf, int offset, int len) throws IOException {
        if (len < 1) {
            return 0;
        }
        while (this.applicationDataQueue.size() == 0) {
            if (this.closed) {
                if (this.failedWithError) {
                    throw new IOException(TLS_ERROR_MESSAGE);
                }
                return -1;
            }
            this.safeReadRecord();
        }
        len = Math.min(len, this.applicationDataQueue.size());
        this.applicationDataQueue.read(buf, offset, len, 0);
        this.applicationDataQueue.removeData(len);
        return len;
    }

    protected void safeReadRecord() throws IOException {
        try {
            this.recordStream.readRecord();
        }
        catch (TlsFatalAlert e) {
            if (!this.closed) {
                this.failWithError((short)2, e.getAlertDescription());
            }
            throw e;
        }
        catch (IOException e) {
            if (!this.closed) {
                this.failWithError((short)2, (short)80);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (!this.closed) {
                this.failWithError((short)2, (short)80);
            }
            throw e;
        }
    }

    protected void safeWriteRecord(short type, byte[] buf, int offset, int len) throws IOException {
        try {
            this.recordStream.writeRecord(type, buf, offset, len);
        }
        catch (TlsFatalAlert e) {
            if (!this.closed) {
                this.failWithError((short)2, e.getAlertDescription());
            }
            throw e;
        }
        catch (IOException e) {
            if (!this.closed) {
                this.failWithError((short)2, (short)80);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (!this.closed) {
                this.failWithError((short)2, (short)80);
            }
            throw e;
        }
    }

    protected void writeData(byte[] buf, int offset, int len) throws IOException {
        if (this.closed) {
            if (this.failedWithError) {
                throw new IOException(TLS_ERROR_MESSAGE);
            }
            throw new IOException("Sorry, connection has been closed, you cannot write more data");
        }
        while (len > 0) {
            if (this.writeExtraEmptyRecords) {
                this.safeWriteRecord((short)23, TlsUtils.EMPTY_BYTES, 0, 0);
            }
            int toWrite = Math.min(len, 16384);
            this.safeWriteRecord((short)23, buf, offset, toWrite);
            offset += toWrite;
            len -= toWrite;
        }
    }

    public OutputStream getOutputStream() {
        return this.tlsOutputStream;
    }

    public InputStream getInputStream() {
        return this.tlsInputStream;
    }

    protected void failWithError(short alertLevel, short alertDescription) throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (alertLevel == 2) {
                this.failedWithError = true;
            }
            this.raiseAlert(alertLevel, alertDescription, null, null);
            this.recordStream.close();
            if (alertLevel == 2) {
                throw new IOException(TLS_ERROR_MESSAGE);
            }
        } else {
            throw new IOException(TLS_ERROR_MESSAGE);
        }
    }

    protected void processFinishedMessage(ByteArrayInputStream buf) throws IOException {
        byte[] verify_data = TlsUtils.readFully(this.expected_verify_data.length, (InputStream)buf);
        this.server_verify_data = verify_data;
        TlsProtocol.assertEmpty(buf);
        if (this.resumed) {
            this.sendFinishedMessage();
            this.recordStream.updateHandshakeData(new byte[]{20, 0, 0, (byte)this.expected_verify_data.length}, 0, 4);
            this.recordStream.updateHandshakeData(verify_data, 0, (byte)this.expected_verify_data.length);
        }
        if (!Arrays.constantTimeAreEqual(this.expected_verify_data, verify_data)) {
            this.failWithError((short)2, (short)51);
        }
    }

    protected void raiseAlert(short alertLevel, short alertDescription, String message, Exception cause) throws IOException {
        this.getPeer().notifyAlertRaised(alertLevel, alertDescription, message, cause);
        byte[] error = new byte[]{(byte)alertLevel, (byte)alertDescription};
        this.safeWriteRecord((short)21, error, 0, 2);
    }

    protected void raiseWarning(short alertDescription, String message) throws IOException {
        this.raiseAlert((short)1, alertDescription, message, null);
    }

    protected void sendCertificateMessage(Certificate certificate) throws IOException {
        ProtocolVersion serverVersion;
        AbstractTlsContext context;
        if (certificate == null) {
            certificate = Certificate.EMPTY_CHAIN;
        }
        if (certificate.getLength() == 0 && !(context = this.getContext()).isServer() && (serverVersion = this.getContext().getServerVersion()).isSSL()) {
            String message = serverVersion.toString() + " client didn't provide credentials";
            this.raiseWarning((short)41, message);
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)11, bos);
        TlsUtils.writeUint24(0, bos);
        certificate.encode(bos);
        byte[] message = bos.toByteArray();
        TlsUtils.writeUint24(message.length - 4, message, 1);
        this.safeWriteRecord((short)22, message, 0, message.length);
    }

    protected void sendChangeCipherSpecMessage() throws IOException {
        byte[] message = new byte[]{1};
        this.safeWriteRecord((short)20, message, 0, message.length);
        this.recordStream.sentWriteCipherSpec();
    }

    protected void sendFinishedMessage() throws IOException {
        byte[] verify_data = this.createVerifyData(this.getContext().isServer());
        this.client_verify_data = this.createVerifyData(this.getContext().isServer());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)20, bos);
        TlsUtils.writeUint24(verify_data.length, bos);
        bos.write(verify_data);
        byte[] message = bos.toByteArray();
        this.safeWriteRecord((short)22, message, 0, message.length);
    }

    protected void sendSupplementalDataMessage(Vector supplementalData) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)23, buf);
        TlsUtils.writeUint24(0, buf);
        TlsProtocol.writeSupplementalData(buf, supplementalData);
        byte[] message = buf.toByteArray();
        TlsUtils.writeUint24(message.length - 4, message, 1);
        this.safeWriteRecord((short)22, message, 0, message.length);
    }

    protected byte[] createVerifyData(boolean isServer) {
        AbstractTlsContext context = this.getContext();
        if (isServer) {
            return TlsUtils.calculateVerifyData(context, "server finished", this.recordStream.getCurrentHash(TlsUtils.SSL_SERVER));
        }
        return TlsUtils.calculateVerifyData(context, "client finished", this.recordStream.getCurrentHash(TlsUtils.SSL_CLIENT));
    }

    public void close() throws IOException {
        this.handleClose(true);
    }

    protected void handleClose(boolean user_canceled) throws IOException {
        if (!this.closed) {
            if (user_canceled && !this.appDataReady) {
                this.raiseWarning((short)90, "User canceled handshake");
            }
            this.failWithError((short)1, (short)0);
        }
    }

    protected void flush() throws IOException {
        this.recordStream.flush();
    }

    protected static boolean arrayContains(short[] a, short n) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != n) continue;
            return true;
        }
        return false;
    }

    protected static boolean arrayContains(int[] a, int n) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != n) continue;
            return true;
        }
        return false;
    }

    protected static void assertEmpty(ByteArrayInputStream buf) throws IOException {
        if (buf.available() > 0) {
            throw new TlsFatalAlert(50);
        }
    }

    protected static byte[] createRandomBlock(SecureRandom random) {
        byte[] result = new byte[32];
        random.nextBytes(result);
        TlsUtils.writeGMTUnixTime(result, 0);
        return result;
    }

    protected static byte[] createRenegotiationInfo(byte[] renegotiated_connection) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        TlsUtils.writeOpaque8(renegotiated_connection, buf);
        return buf.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void establishMasterSecret(TlsContext context, TlsKeyExchange keyExchange) throws IOException {
        byte[] pre_master_secret = keyExchange.generatePremasterSecret();
        try {
            context.getSecurityParameters().masterSecret = TlsUtils.calculateMasterSecret(context, pre_master_secret);
        }
        finally {
            if (pre_master_secret != null) {
                Arrays.fill(pre_master_secret, (byte)0);
            }
        }
    }

    protected static Hashtable readExtensions(ByteArrayInputStream input) throws IOException {
        if (input.available() < 1) {
            return null;
        }
        byte[] extBytes = TlsUtils.readOpaque16(input);
        TlsProtocol.assertEmpty(input);
        ByteArrayInputStream buf = new ByteArrayInputStream(extBytes);
        Hashtable<Integer, byte[]> extensions = new Hashtable<Integer, byte[]>();
        while (buf.available() > 0) {
            byte[] extValue;
            Integer extType = Integers.valueOf(TlsUtils.readUint16(buf));
            if (null == extensions.put(extType, extValue = TlsUtils.readOpaque16(buf))) continue;
            throw new TlsFatalAlert(47);
        }
        return extensions;
    }

    protected static Vector readSupplementalDataMessage(ByteArrayInputStream input) throws IOException {
        byte[] supp_data = TlsUtils.readOpaque24(input);
        TlsProtocol.assertEmpty(input);
        ByteArrayInputStream buf = new ByteArrayInputStream(supp_data);
        Vector<SupplementalDataEntry> supplementalData = new Vector<SupplementalDataEntry>();
        while (buf.available() > 0) {
            int supp_data_type = TlsUtils.readUint16(buf);
            byte[] data = TlsUtils.readOpaque16(buf);
            supplementalData.addElement(new SupplementalDataEntry(supp_data_type, data));
        }
        return supplementalData;
    }

    protected static void writeExtensions(OutputStream output, Hashtable extensions) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        Enumeration keys = extensions.keys();
        while (keys.hasMoreElements()) {
            Integer extType = (Integer)keys.nextElement();
            byte[] extValue = (byte[])extensions.get(extType);
            TlsUtils.writeUint16(extType, buf);
            TlsUtils.writeOpaque16(extValue, buf);
        }
        byte[] extBytes = buf.toByteArray();
        TlsUtils.writeOpaque16(extBytes, output);
    }

    protected static void writeSupplementalData(OutputStream output, Vector supplementalData) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        for (int i = 0; i < supplementalData.size(); ++i) {
            SupplementalDataEntry entry = (SupplementalDataEntry)supplementalData.elementAt(i);
            TlsUtils.writeUint16(entry.getDataType(), buf);
            TlsUtils.writeOpaque16(entry.getData(), buf);
        }
        byte[] supp_data = buf.toByteArray();
        TlsUtils.writeOpaque24(supp_data, output);
    }

    protected static int getPRFAlgorithm(int ciphersuite) {
        switch (ciphersuite) {
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49195: 
            case 49197: 
            case 49199: 
            case 49201: {
                return 1;
            }
            case 157: 
            case 159: 
            case 161: 
            case 163: 
            case 165: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49196: 
            case 49198: 
            case 49200: 
            case 49202: {
                return 2;
            }
        }
        return 0;
    }
}

