/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.kems;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.openecard.bouncycastle.crypto.CipherParameters;
import org.openecard.bouncycastle.crypto.DerivationFunction;
import org.openecard.bouncycastle.crypto.KeyEncapsulation;
import org.openecard.bouncycastle.crypto.params.ECKeyParameters;
import org.openecard.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.openecard.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.openecard.bouncycastle.crypto.params.KDFParameters;
import org.openecard.bouncycastle.crypto.params.KeyParameter;
import org.openecard.bouncycastle.math.ec.ECPoint;
import org.openecard.bouncycastle.util.BigIntegers;

public class ECIESKeyEncapsulation
implements KeyEncapsulation {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DerivationFunction kdf;
    private SecureRandom rnd;
    private ECKeyParameters key;
    private boolean CofactorMode;
    private boolean OldCofactorMode;
    private boolean SingleHashMode;

    public ECIESKeyEncapsulation(DerivationFunction kdf, SecureRandom rnd) {
        this.kdf = kdf;
        this.rnd = rnd;
        this.CofactorMode = false;
        this.OldCofactorMode = false;
        this.SingleHashMode = false;
    }

    public ECIESKeyEncapsulation(DerivationFunction kdf, SecureRandom rnd, boolean cofactorMode, boolean oldCofactorMode, boolean singleHashMode) {
        this.kdf = kdf;
        this.rnd = rnd;
        this.CofactorMode = cofactorMode;
        this.OldCofactorMode = oldCofactorMode;
        this.SingleHashMode = singleHashMode;
    }

    @Override
    public void init(CipherParameters key) throws IllegalArgumentException {
        if (!(key instanceof ECKeyParameters)) {
            throw new IllegalArgumentException("EC key required");
        }
        this.key = (ECKeyParameters)key;
    }

    @Override
    public CipherParameters encrypt(byte[] out, int outOff, int keyLen) throws IllegalArgumentException {
        byte[] kdfInput;
        if (!(this.key instanceof ECPublicKeyParameters)) {
            throw new IllegalArgumentException("Public key required for encryption");
        }
        BigInteger n = this.key.getParameters().getN();
        BigInteger h = this.key.getParameters().getH();
        BigInteger r = BigIntegers.createRandomInRange(ONE, n, this.rnd);
        ECPoint gTilde = this.key.getParameters().getG().multiply(r);
        byte[] C = gTilde.getEncoded();
        System.arraycopy(C, 0, out, outOff, C.length);
        BigInteger rPrime = this.CofactorMode ? r.multiply(h).mod(n) : r;
        ECPoint hTilde = ((ECPublicKeyParameters)this.key).getQ().multiply(rPrime);
        int PEHlen = (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
        byte[] PEH = BigIntegers.asUnsignedByteArray(PEHlen, hTilde.getX().toBigInteger());
        if (this.SingleHashMode) {
            kdfInput = new byte[C.length + PEH.length];
            System.arraycopy(C, 0, kdfInput, 0, C.length);
            System.arraycopy(PEH, 0, kdfInput, C.length, PEH.length);
        } else {
            kdfInput = PEH;
        }
        this.kdf.init(new KDFParameters(kdfInput, null));
        byte[] K = new byte[keyLen];
        this.kdf.generateBytes(K, 0, K.length);
        return new KeyParameter(K);
    }

    public CipherParameters encrypt(byte[] out, int keyLen) {
        return this.encrypt(out, 0, keyLen);
    }

    @Override
    public CipherParameters decrypt(byte[] in, int inOff, int inLen, int keyLen) throws IllegalArgumentException {
        byte[] kdfInput;
        if (!(this.key instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("Private key required for encryption");
        }
        BigInteger n = this.key.getParameters().getN();
        BigInteger h = this.key.getParameters().getH();
        byte[] C = new byte[inLen];
        System.arraycopy(in, inOff, C, 0, inLen);
        ECPoint gTilde = this.key.getParameters().getCurve().decodePoint(C);
        ECPoint gHat = this.CofactorMode || this.OldCofactorMode ? gTilde.multiply(h) : gTilde;
        BigInteger xHat = this.CofactorMode ? ((ECPrivateKeyParameters)this.key).getD().multiply(h.modInverse(n)).mod(n) : ((ECPrivateKeyParameters)this.key).getD();
        ECPoint hTilde = gHat.multiply(xHat);
        int PEHlen = (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
        byte[] PEH = BigIntegers.asUnsignedByteArray(PEHlen, hTilde.getX().toBigInteger());
        if (this.SingleHashMode) {
            kdfInput = new byte[C.length + PEH.length];
            System.arraycopy(C, 0, kdfInput, 0, C.length);
            System.arraycopy(PEH, 0, kdfInput, C.length, PEH.length);
        } else {
            kdfInput = PEH;
        }
        this.kdf.init(new KDFParameters(kdfInput, null));
        byte[] K = new byte[keyLen];
        this.kdf.generateBytes(K, 0, K.length);
        return new KeyParameter(K);
    }

    public CipherParameters decrypt(byte[] in, int keyLen) {
        return this.decrypt(in, 0, in.length, keyLen);
    }
}

