/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jci.monitor.FilesystemAlterationMonitor;
import org.openecard.addon.AddonRegistry;
import org.openecard.addon.PluginDirectoryAlterationListener;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.addon.manifest.AppExtensionSpecification;
import org.openecard.addon.manifest.AppPluginSpecification;
import org.openecard.addon.manifest.LocalizedString;
import org.openecard.addon.manifest.ProtocolPluginSpecification;
import org.openecard.common.util.FileUtils;
import org.openecard.ws.marshal.WSMarshallerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRegistry
implements AddonRegistry {
    private static final Logger logger = LoggerFactory.getLogger(FileRegistry.class.getName());
    private static final ArrayList<AddonSpecification> registeredAddons = new ArrayList();
    private static final HashMap<String, File> files = new HashMap();

    public FileRegistry() throws WSMarshallerException {
        String pluginsPath;
        try {
            pluginsPath = FileUtils.getHomeConfigDir() + File.separator + "plugins" + File.separator;
        }
        catch (SecurityException e) {
            logger.error("Failed to get plugin directory; FileRegistry won't work.", e);
            return;
        }
        catch (IOException e) {
            logger.error("Failed to get plugin directory; FileRegistry won't work.", e);
            return;
        }
        this.startFileMonitor(pluginsPath);
    }

    private void startFileMonitor(String pluginsPath) throws WSMarshallerException {
        File f = new File(pluginsPath);
        logger.debug("Starting FilesystemAlterationMonitor on Path: {}", (Object)f.getPath());
        FilesystemAlterationMonitor fam = new FilesystemAlterationMonitor();
        fam.addListener(f, new PluginDirectoryAlterationListener(this));
        fam.start();
    }

    public void register(AddonSpecification desc, File file) {
        registeredAddons.add(desc);
        files.put(desc.getId(), file);
    }

    public void unregister(File file) {
        Set<Map.Entry<String, File>> entrySet = files.entrySet();
        for (Map.Entry<String, File> next : entrySet) {
            if (!next.getValue().equals(file)) continue;
            String id = next.getKey();
            AddonSpecification desc = this.search(id);
            registeredAddons.remove(desc);
            files.remove(id);
            logger.debug("Successfully removed addon {}", (Object)file.getName());
            break;
        }
    }

    @Override
    public Set<AddonSpecification> listPlugins() {
        HashSet<AddonSpecification> list = new HashSet<AddonSpecification>();
        list.addAll(registeredAddons);
        return list;
    }

    @Override
    public AddonSpecification search(String id) {
        for (AddonSpecification desc : registeredAddons) {
            if (!desc.getId().equals(id)) continue;
            return desc;
        }
        return null;
    }

    @Override
    public Set<AddonSpecification> searchByName(String name) {
        HashSet<AddonSpecification> matchingAddons = new HashSet<AddonSpecification>();
        for (AddonSpecification desc : registeredAddons) {
            for (LocalizedString s : desc.getLocalizedName()) {
                if (!s.getValue().equals(name)) continue;
                matchingAddons.add(desc);
            }
        }
        return matchingAddons;
    }

    @Override
    public Set<AddonSpecification> searchIFDProtocol(String uri) {
        HashSet<AddonSpecification> matchingAddons = new HashSet<AddonSpecification>();
        for (AddonSpecification desc : registeredAddons) {
            ProtocolPluginSpecification protocolDesc = desc.searchIFDActionByURI(uri);
            if (protocolDesc == null) continue;
            matchingAddons.add(desc);
        }
        return matchingAddons;
    }

    @Override
    public Set<AddonSpecification> searchSALProtocol(String uri) {
        HashSet<AddonSpecification> matchingAddons = new HashSet<AddonSpecification>();
        for (AddonSpecification desc : registeredAddons) {
            ProtocolPluginSpecification protocolDesc = desc.searchSALActionByURI(uri);
            if (protocolDesc == null) continue;
            matchingAddons.add(desc);
        }
        return matchingAddons;
    }

    @Override
    public ClassLoader downloadPlugin(AddonSpecification addonSpec) {
        String aId = addonSpec.getId();
        URL[] url = new URL[1];
        try {
            url[0] = files.get(aId).toURI().toURL();
        }
        catch (MalformedURLException e) {
            logger.error(e.getMessage(), e);
        }
        URLClassLoader ucl = new URLClassLoader(url);
        return ucl;
    }

    @Override
    public Set<AddonSpecification> searchByResourceName(String resourceName) {
        HashSet<AddonSpecification> matchingAddons = new HashSet<AddonSpecification>();
        for (AddonSpecification desc : registeredAddons) {
            AppPluginSpecification actionDesc = desc.searchByResourceName(resourceName);
            if (actionDesc == null) continue;
            matchingAddons.add(desc);
        }
        return matchingAddons;
    }

    @Override
    public Set<AddonSpecification> searchByActionId(String actionId) {
        HashSet<AddonSpecification> matchingAddons = new HashSet<AddonSpecification>();
        for (AddonSpecification desc : registeredAddons) {
            AppExtensionSpecification actionDesc = desc.searchByActionId(actionId);
            if (actionDesc == null) continue;
            matchingAddons.add(desc);
        }
        return matchingAddons;
    }
}

