/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.openecard.addon.AddonManager;
import org.openecard.addon.AddonNotFoundException;
import org.openecard.addon.HighestVersionSelector;
import org.openecard.addon.SelectionStrategy;
import org.openecard.addon.bind.AppExtensionAction;
import org.openecard.addon.bind.AppPluginAction;
import org.openecard.addon.ifd.IFDProtocol;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.addon.sal.SALProtocol;

public class AddonSelector {
    private final AddonManager manager;
    private final Map<String, AddonSpecification> ifdCache;
    private final Map<String, AddonSpecification> salCache;
    private final Map<String, AddonSpecification> extensionCache;
    private final Map<String, AddonSpecification> pluginCache;
    private SelectionStrategy strategy;

    public AddonSelector(AddonManager manager) {
        this.manager = manager;
        this.ifdCache = new HashMap<String, AddonSpecification>();
        this.salCache = new HashMap<String, AddonSpecification>();
        this.extensionCache = new HashMap<String, AddonSpecification>();
        this.pluginCache = new HashMap<String, AddonSpecification>();
        this.setStrategy(new HighestVersionSelector());
    }

    public final void setStrategy(SelectionStrategy strategy) {
        this.strategy = strategy;
    }

    public IFDProtocol getIFDProtocol(@Nonnull String uri) throws AddonNotFoundException {
        Set<AddonSpecification> addons = this.manager.getRegistry().searchIFDProtocol(uri);
        if (addons.isEmpty()) {
            throw new AddonNotFoundException("No Add-on for IFD protocol '" + uri + "' found.");
        }
        AddonSpecification addon = this.strategy.select(addons);
        return this.manager.getIFDProtocol(addon, uri);
    }

    public SALProtocol getSALProtocol(@Nonnull String uri) throws AddonNotFoundException {
        Set<AddonSpecification> addons = this.manager.getRegistry().searchSALProtocol(uri);
        if (addons.isEmpty()) {
            throw new AddonNotFoundException("No Add-on for SAL protocol '" + uri + "' found.");
        }
        AddonSpecification addon = this.strategy.select(addons);
        return this.manager.getSALProtocol(addon, uri);
    }

    public AppExtensionAction getAppExtensionAction(@Nonnull String actionId) throws AddonNotFoundException {
        Set<AddonSpecification> addons = this.manager.getRegistry().searchByActionId(actionId);
        if (addons.isEmpty()) {
            throw new AddonNotFoundException("No Add-on for action ID '" + actionId + "' found.");
        }
        AddonSpecification addon = this.strategy.select(addons);
        return this.manager.getAppExtensionAction(addon, actionId);
    }

    public AppPluginAction getAppPluginAction(@Nonnull String resourceName) throws AddonNotFoundException {
        Set<AddonSpecification> addons = this.manager.getRegistry().searchByResourceName(resourceName);
        if (addons.isEmpty()) {
            throw new AddonNotFoundException("No Add-on for resource '" + resourceName + "' found.");
        }
        AddonSpecification addon = this.strategy.select(addons);
        return this.manager.getAppPluginAction(addon, resourceName);
    }
}

