/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.AuthenticationObjectChoice;
import org.openecard.common.tlv.iso7816.CertificateChoice;
import org.openecard.common.tlv.iso7816.GenericPathOrObjects;
import org.openecard.common.tlv.iso7816.PrivateKeyChoice;

public class CIOChoice
extends TLV {
    private TLV actualElement;
    private String elementName;
    private GenericPathOrObjects<PrivateKeyChoice> privateKeys = null;
    private TLV publicKeys = null;
    private TLV trustedPublicKeys = null;
    private TLV secretKeys = null;
    private GenericPathOrObjects<CertificateChoice> certificates = null;
    private TLV trustedCertificates = null;
    private TLV usefulCertificates = null;
    private TLV dataContainerObjects = null;
    private GenericPathOrObjects<AuthenticationObjectChoice> authObjects = null;
    private TLV futureExtension = null;

    public CIOChoice(TLV tlv) throws TLVException {
        super(tlv);
        Parser p = new Parser(tlv);
        if (p.match(new Tag(TagClass.CONTEXT, false, 0L))) {
            this.actualElement = this.privateKeys = new GenericPathOrObjects<PrivateKeyChoice>(p.next(0), PrivateKeyChoice.class);
            this.elementName = "privateKeys";
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 1L))) {
            this.actualElement = this.publicKeys = p.next(0);
            this.elementName = "publicKeys";
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 2L))) {
            this.actualElement = this.trustedPublicKeys = p.next(0);
            this.elementName = "trustedPublicKeys";
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 3L))) {
            this.actualElement = this.secretKeys = p.next(0);
            this.elementName = "secretKeys";
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 4L))) {
            this.actualElement = this.certificates = new GenericPathOrObjects<CertificateChoice>(p.next(0), CertificateChoice.class);
            this.elementName = "certificates";
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 5L))) {
            this.actualElement = this.trustedCertificates = p.next(0);
            this.elementName = "trustedCertificates";
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 6L))) {
            this.actualElement = this.usefulCertificates = p.next(0);
            this.elementName = "usefulCertificates";
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 7L))) {
            this.actualElement = this.dataContainerObjects = p.next(0);
            this.elementName = "dataContainerObjects";
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 8L))) {
            this.actualElement = this.authObjects = new GenericPathOrObjects<AuthenticationObjectChoice>(p.next(0), AuthenticationObjectChoice.class);
            this.elementName = "authObjects";
        } else {
            this.actualElement = this.futureExtension = p.next(0);
            this.elementName = "futureExtension";
            if (this.futureExtension == null) {
                throw new TLVException("No element in CIOChoice");
            }
        }
    }

    public String getElementName() {
        return this.elementName;
    }

    public TLV getElement() {
        return this.actualElement;
    }
}

