/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.pqc.asn1;

import java.math.BigInteger;
import org.openecard.bouncycastle.asn1.ASN1EncodableVector;
import org.openecard.bouncycastle.asn1.ASN1Integer;
import org.openecard.bouncycastle.asn1.ASN1Object;
import org.openecard.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.openecard.bouncycastle.asn1.ASN1OctetString;
import org.openecard.bouncycastle.asn1.ASN1Primitive;
import org.openecard.bouncycastle.asn1.ASN1Sequence;
import org.openecard.bouncycastle.asn1.DEROctetString;
import org.openecard.bouncycastle.asn1.DERSequence;
import org.openecard.bouncycastle.pqc.jcajce.spec.McEliecePublicKeySpec;

public class McEliecePublicKey
extends ASN1Object {
    private McEliecePublicKeySpec keySpec;

    public McEliecePublicKey(McEliecePublicKeySpec keySpec) {
        this.keySpec = keySpec;
    }

    public McEliecePublicKey(ASN1Sequence seq) {
        String oid = ((ASN1ObjectIdentifier)seq.getObjectAt(0)).getId();
        BigInteger bigN = ((ASN1Integer)seq.getObjectAt(1)).getValue();
        int n = bigN.intValue();
        BigInteger bigT = ((ASN1Integer)seq.getObjectAt(2)).getValue();
        int t = bigT.intValue();
        byte[] matrixG = ((ASN1OctetString)seq.getObjectAt(3)).getOctets();
        this.keySpec = new McEliecePublicKeySpec(oid, t, n, matrixG);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1ObjectIdentifier(this.keySpec.getOIDString()));
        v.add(new ASN1Integer(this.keySpec.getN()));
        v.add(new ASN1Integer(this.keySpec.getT()));
        v.add(new DEROctetString(this.keySpec.getG().getEncoded()));
        return new DERSequence(v);
    }

    public McEliecePublicKeySpec getKeySpec() {
        return this.keySpec;
    }
}

