/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.IOException;
import java.util.Hashtable;
import org.openecard.bouncycastle.crypto.tls.AbstractTlsClient;
import org.openecard.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import org.openecard.bouncycastle.crypto.tls.TlsCipher;
import org.openecard.bouncycastle.crypto.tls.TlsCipherFactory;
import org.openecard.bouncycastle.crypto.tls.TlsDHEKeyExchange;
import org.openecard.bouncycastle.crypto.tls.TlsDHKeyExchange;
import org.openecard.bouncycastle.crypto.tls.TlsECDHEKeyExchange;
import org.openecard.bouncycastle.crypto.tls.TlsECDHKeyExchange;
import org.openecard.bouncycastle.crypto.tls.TlsFatalAlert;
import org.openecard.bouncycastle.crypto.tls.TlsKeyExchange;
import org.openecard.bouncycastle.crypto.tls.TlsRSAKeyExchange;

public abstract class DefaultTlsClient
extends AbstractTlsClient {
    protected TlsCipherFactory cipherFactory;

    public DefaultTlsClient(String fqdn) {
        this(new DefaultTlsCipherFactory(), fqdn);
    }

    public DefaultTlsClient(TlsCipherFactory cipherFactory, String fqdn) {
        super(fqdn);
        this.cipherFactory = cipherFactory;
    }

    public static int[] getDefaultCipherSuites() {
        return new int[]{57, 56, 51, 50, 22, 19, 53, 47, 10};
    }

    @Override
    public int[] getCipherSuites() {
        return new int[]{57, 56, 51, 50, 22, 19, 53, 47, 10, 5};
    }

    @Override
    public void processServerExtensions(Hashtable serverExtensions) {
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        switch (this.selectedCipherSuite) {
            case 5: 
            case 10: 
            case 47: 
            case 53: {
                return this.createRSAKeyExchange();
            }
            case 13: 
            case 48: 
            case 54: {
                return this.createDHKeyExchange(7);
            }
            case 16: 
            case 49: 
            case 55: {
                return this.createDHKeyExchange(9);
            }
            case 19: 
            case 50: 
            case 56: {
                return this.createDHEKeyExchange(3);
            }
            case 22: 
            case 51: 
            case 57: {
                return this.createDHEKeyExchange(5);
            }
            case 49154: 
            case 49155: 
            case 49156: 
            case 49157: {
                return this.createECDHKeyExchange(16);
            }
            case 49159: 
            case 49160: 
            case 49161: 
            case 49162: {
                return this.createECDHEKeyExchange(17);
            }
            case 49164: 
            case 49165: 
            case 49166: 
            case 49167: {
                return this.createECDHKeyExchange(18);
            }
            case 49169: 
            case 49170: 
            case 49171: 
            case 49172: {
                return this.createECDHEKeyExchange(19);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsCipher getCipher() throws IOException {
        switch (this.selectedCipherSuite) {
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 49155: 
            case 49160: 
            case 49165: 
            case 49170: {
                return this.cipherFactory.createCipher(this.context, 7, 2);
            }
            case 5: 
            case 49154: 
            case 49159: 
            case 49164: 
            case 49169: {
                return this.cipherFactory.createCipher(this.context, 2, 2);
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 49156: 
            case 49161: 
            case 49166: 
            case 49171: {
                return this.cipherFactory.createCipher(this.context, 8, 2);
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 49157: 
            case 49162: 
            case 49167: 
            case 49172: {
                return this.cipherFactory.createCipher(this.context, 9, 2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createDHKeyExchange(int keyExchange) {
        return new TlsDHKeyExchange(this.context, keyExchange);
    }

    protected TlsKeyExchange createDHEKeyExchange(int keyExchange) {
        return new TlsDHEKeyExchange(this.context, keyExchange);
    }

    protected TlsKeyExchange createECDHKeyExchange(int keyExchange) {
        return new TlsECDHKeyExchange(this.context, keyExchange);
    }

    protected TlsKeyExchange createECDHEKeyExchange(int keyExchange) {
        return new TlsECDHEKeyExchange(this.context, keyExchange);
    }

    protected TlsKeyExchange createRSAKeyExchange() {
        return new TlsRSAKeyExchange(this.context);
    }
}

