/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac;

import org.openecard.common.apdu.GeneralAuthenticate;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.apdu.exception.APDUException;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.sal.protocol.exception.ProtocolException;
import org.openecard.common.util.ByteUtils;
import org.openecard.sal.protocol.eac.apdu.MSESetATCA;

public class ChipAuthentication {
    private final Dispatcher dispatcher;
    private final byte[] slotHandle;

    public ChipAuthentication(Dispatcher dispatcher, byte[] slotHandle) {
        this.dispatcher = dispatcher;
        this.slotHandle = slotHandle;
    }

    public void mseSetAT(byte[] oID, byte[] keyID) throws ProtocolException {
        try {
            MSESetATCA mseSetAT = new MSESetATCA(oID, keyID);
            mseSetAT.transmit(this.dispatcher, this.slotHandle);
        }
        catch (APDUException e) {
            throw new ProtocolException(e.getResult());
        }
    }

    public byte[] generalAuthenticate(byte[] key) throws ProtocolException {
        try {
            if (key[0] != 4) {
                key = ByteUtils.concatenate((byte)4, key);
            }
            GeneralAuthenticate generalAuthenticate = new GeneralAuthenticate(-128, key);
            CardResponseAPDU response = generalAuthenticate.transmit(this.dispatcher, this.slotHandle);
            return response.getData();
        }
        catch (APDUException e) {
            throw new ProtocolException(e.getResult());
        }
    }
}

