/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio.wrapper;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import org.openecard.ifd.scio.IFDException;
import org.openecard.ifd.scio.wrapper.DeadAndAliveTerminals;
import org.openecard.ifd.scio.wrapper.SCCard;
import org.openecard.ifd.scio.wrapper.SCChannel;
import org.openecard.ifd.scio.wrapper.SCTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCWrapper {
    private static final Logger _logger = LoggerFactory.getLogger(SCWrapper.class);
    private final CardTerminals terminals = new DeadAndAliveTerminals();
    private final SecureRandom secureRandom = new SecureRandom();
    private final ConcurrentSkipListMap<String, SCTerminal> scTerminals = new ConcurrentSkipListMap();

    public byte[] createHandle(int size) {
        byte[] handle = new byte[size];
        this.secureRandom.nextBytes(handle);
        return handle;
    }

    public synchronized SCChannel getChannel(byte[] handle) throws IFDException {
        for (SCTerminal t : this.getTerminals()) {
            if (!t.isConnected()) continue;
            SCCard c = t.getCard();
            try {
                SCChannel ch = c.getChannel(handle);
                return ch;
            }
            catch (IFDException ex) {
            }
        }
        IFDException ex = new IFDException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", "Slot handle does not exist.");
        _logger.warn(ex.getMessage(), ex);
        throw ex;
    }

    public synchronized SCCard getCard(byte[] handle) throws IFDException {
        for (SCTerminal t : this.getTerminals()) {
            if (!t.isConnected()) continue;
            SCCard c = t.getCard();
            try {
                c.getChannel(handle);
                return c;
            }
            catch (IFDException ex) {
            }
        }
        IFDException ex = new IFDException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", "Slot handle does not exist.");
        _logger.warn(ex.getMessage(), ex);
        throw ex;
    }

    public SCTerminal getTerminal(byte[] handle) throws IFDException {
        for (SCTerminal t : this.getTerminals()) {
            if (!t.isConnected()) continue;
            SCCard c = t.getCard();
            try {
                c.getChannel(handle);
                return t;
            }
            catch (IFDException ex) {
            }
        }
        IFDException ex = new IFDException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", "Slot handle does not exist.");
        _logger.warn(ex.getMessage(), ex);
        throw ex;
    }

    public synchronized SCTerminal getTerminal(String ifdName) throws IFDException {
        SCTerminal t = this.getTerminal(ifdName, false);
        return t;
    }

    public synchronized SCTerminal getTerminal(String ifdName, boolean update) throws IFDException {
        SCTerminal t;
        if (update) {
            this.updateTerminals();
        }
        if ((t = this.scTerminals.get(ifdName)) == null) {
            IFDException ex = new IFDException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/terminal#unknownIFD", "IFD with name '" + ifdName + "' does not exist.");
            _logger.warn(ex.getMessage(), ex);
            throw ex;
        }
        return t;
    }

    public synchronized List<SCTerminal> getTerminals() {
        try {
            List<SCTerminal> list = this.getTerminals(false);
            return list;
        }
        catch (IFDException ex) {
            _logger.error(ex.getMessage(), ex);
            return null;
        }
    }

    public synchronized List<SCTerminal> getTerminals(boolean update) throws IFDException {
        if (update) {
            this.updateTerminals();
        }
        ArrayList<SCTerminal> list = new ArrayList<SCTerminal>(this.scTerminals.values());
        return list;
    }

    public synchronized List<String> getTerminalNames() {
        try {
            List<String> list = this.getTerminalNames(false);
            return list;
        }
        catch (IFDException ex) {
            _logger.error(ex.getMessage(), ex);
            return null;
        }
    }

    public synchronized List<String> getTerminalNames(boolean update) throws IFDException {
        if (update) {
            this.updateTerminals();
        }
        ArrayList<String> list = new ArrayList<String>(this.scTerminals.keySet());
        return list;
    }

    public synchronized void updateTerminals() {
        List<CardTerminal> ts;
        ConcurrentSkipListSet deleted = new ConcurrentSkipListSet(this.scTerminals.keySet());
        try {
            ts = this.terminals.list();
        }
        catch (CardException ex) {
            ts = new ArrayList<CardTerminal>(0);
        }
        for (CardTerminal t : ts) {
            if (this.scTerminals.containsKey(t.getName())) {
                deleted.remove(t.getName());
                this.scTerminals.get(t.getName()).updateTerminal();
                continue;
            }
            SCTerminal newTerm = new SCTerminal(t, this);
            this.scTerminals.put(t.getName(), newTerm);
        }
        for (String s : deleted) {
            this.scTerminals.remove(s);
        }
    }

    public synchronized boolean waitForChange(long timeout) throws IFDException {
        try {
            return this.terminals.waitForChange(timeout);
        }
        catch (CardException ex) {
            throw new IFDException(ex);
        }
    }

    public synchronized boolean waitForChange() throws IFDException {
        return this.waitForChange(0L);
    }

    public synchronized void releaseAll() {
        this.updateTerminals();
        for (SCTerminal t : this.getTerminals()) {
            try {
                t.disconnect();
            }
            catch (CardException cardException) {}
        }
    }
}

