/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.pincompare;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticate;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticateResponse;
import iso.std.iso_iec._24727.tech.schema.DIDScopeType;
import iso.std.iso_iec._24727.tech.schema.DIDStructureType;
import iso.std.iso_iec._24727.tech.schema.DifferentialIdentityServiceActionName;
import iso.std.iso_iec._24727.tech.schema.InputUnitType;
import iso.std.iso_iec._24727.tech.schema.PasswordAttributesType;
import iso.std.iso_iec._24727.tech.schema.PinInputType;
import iso.std.iso_iec._24727.tech.schema.Transmit;
import iso.std.iso_iec._24727.tech.schema.TransmitResponse;
import iso.std.iso_iec._24727.tech.schema.VerifyUser;
import iso.std.iso_iec._24727.tech.schema.VerifyUserResponse;
import java.math.BigInteger;
import java.util.Map;
import org.openecard.addon.sal.FunctionType;
import org.openecard.addon.sal.ProtocolStep;
import org.openecard.common.ECardException;
import org.openecard.common.WSHelper;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.sal.Assert;
import org.openecard.common.sal.anytype.PINCompareMarkerType;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.sal.util.SALUtils;
import org.openecard.common.util.PINUtils;
import org.openecard.sal.protocol.pincompare.anytype.PINCompareDIDAuthenticateInputType;
import org.openecard.sal.protocol.pincompare.anytype.PINCompareDIDAuthenticateOutputType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DIDAuthenticateStep
implements ProtocolStep<DIDAuthenticate, DIDAuthenticateResponse> {
    private static final Logger logger = LoggerFactory.getLogger(DIDAuthenticateStep.class);
    private final Dispatcher dispatcher;

    public DIDAuthenticateStep(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public FunctionType getFunctionType() {
        return FunctionType.DIDAuthenticate;
    }

    @Override
    public DIDAuthenticateResponse perform(DIDAuthenticate request, Map<String, Object> internalData) {
        DIDAuthenticateResponse response = (DIDAuthenticateResponse)WSHelper.makeResponse(DIDAuthenticateResponse.class, WSHelper.makeResultOK());
        try {
            byte[] responseCode;
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            String didName = SALUtils.getDIDName(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(internalData, connectionHandle);
            PINCompareDIDAuthenticateInputType pinCompareInput = new PINCompareDIDAuthenticateInputType(request.getAuthenticationProtocolData());
            PINCompareDIDAuthenticateOutputType pinCompareOutput = pinCompareInput.getOutputType();
            byte[] cardApplication = request.getDIDScope() != null && request.getDIDScope().equals((Object)DIDScopeType.GLOBAL) ? cardStateEntry.getImplicitlySelectedApplicationIdentifier() : connectionHandle.getCardApplication();
            Assert.securityConditionDID(cardStateEntry, cardApplication, didName, DifferentialIdentityServiceActionName.DID_AUTHENTICATE);
            DIDStructureType didStructure = cardStateEntry.getDIDStructure(didName, cardApplication);
            PINCompareMarkerType pinCompareMarker = new PINCompareMarkerType(didStructure.getDIDMarker());
            byte keyRef = pinCompareMarker.getPINRef().getKeyRef()[0];
            byte[] slotHandle = connectionHandle.getSlotHandle();
            PasswordAttributesType attributes = pinCompareMarker.getPasswordAttributes();
            String rawPIN = pinCompareInput.getPIN();
            byte[] template = new byte[]{0, 32, 0, keyRef};
            if (rawPIN == null || rawPIN.isEmpty()) {
                VerifyUser verify = new VerifyUser();
                verify.setSlotHandle(slotHandle);
                InputUnitType inputUnit = new InputUnitType();
                verify.setInputUnit(inputUnit);
                PinInputType pinInput = new PinInputType();
                inputUnit.setPinInput(pinInput);
                pinInput.setIndex(BigInteger.ZERO);
                pinInput.setPasswordAttributes(attributes);
                verify.setTemplate(template);
                VerifyUserResponse verifyR = (VerifyUserResponse)this.dispatcher.deliver(verify);
                WSHelper.checkResult(verifyR);
                responseCode = verifyR.getResponse();
            } else {
                Transmit verifyTransmit = PINUtils.buildVerifyTransmit(rawPIN, attributes, template, slotHandle);
                TransmitResponse transResp = (TransmitResponse)this.dispatcher.deliver(verifyTransmit);
                WSHelper.checkResult(transResp);
                responseCode = transResp.getOutputAPDU().get(0);
            }
            CardResponseAPDU verifyResponseAPDU = new CardResponseAPDU(responseCode);
            if (verifyResponseAPDU.isWarningProcessed()) {
                pinCompareOutput.setRetryCounter(new BigInteger(Integer.toString(verifyResponseAPDU.getSW2() & 0xF)));
            }
            cardStateEntry.addAuthenticated(didName, cardApplication);
            response.setAuthenticationProtocolData(pinCompareOutput.getAuthDataType());
        }
        catch (ECardException e) {
            logger.error(e.getMessage(), e);
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }
}

