/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac.gui;

import org.openecard.common.I18n;
import org.openecard.common.sal.anytype.PACEMarkerType;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.definition.Step;
import org.openecard.gui.definition.Text;
import org.openecard.sal.protocol.eac.EACData;

public class PINStep
extends Step {
    public static final String STEP_ID = "PROTOCOL_EAC_GUI_STEP_PIN";
    private static final String TITLE = "step_pace_title";
    private static final String DESCRIPTION = "step_pace_description";
    private static final String DESCRIPTION_NATIVE = "step_pace_native_description";
    private static final String NOTICE = "eac_forward_notice";
    public static final String PIN_FIELD = "PACE_PIN_FIELD";
    private final I18n langEac = I18n.getTranslation("eac");
    private final I18n langPace = I18n.getTranslation("pace");
    private final String pinType;
    private PACEMarkerType paceMarker;

    public PINStep(EACData eacData, boolean capturePin, PACEMarkerType paceMarker) {
        super(STEP_ID);
        this.pinType = this.langPace.translationForKey(eacData.passwordType, new Object[0]);
        this.paceMarker = paceMarker;
        this.setTitle(this.langPace.translationForKey(TITLE, this.pinType));
        this.setDescription(this.langPace.translationForKey(DESCRIPTION, this.pinType));
        if (capturePin) {
            this.addSoftwareElements();
        } else {
            this.addTerminalElements();
        }
    }

    private void addSoftwareElements() {
        this.setResetOnLoad(true);
        Text description = new Text();
        description.setText(this.langPace.translationForKey(DESCRIPTION, this.pinType));
        this.getInputInfoUnits().add(description);
        PasswordField pinInputField = new PasswordField(PIN_FIELD);
        pinInputField.setDescription(this.pinType);
        pinInputField.setMinLength(this.paceMarker.getMinLength());
        pinInputField.setMaxLength(this.paceMarker.getMaxLength());
        this.getInputInfoUnits().add(pinInputField);
        Text notice = new Text();
        notice.setText(this.langEac.translationForKey(NOTICE, this.pinType));
        this.getInputInfoUnits().add(notice);
    }

    private void addTerminalElements() {
        this.setInstantReturn(true);
        Text description = new Text();
        description.setText(this.langPace.translationForKey(DESCRIPTION_NATIVE, this.pinType));
        this.getInputInfoUnits().add(description);
        Text notice = new Text();
        notice.setText(this.langEac.translationForKey(NOTICE, this.pinType));
        this.getInputInfoUnits().add(notice);
    }
}

