/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openecard.crypto.common.asn1.cvc.CHAT;
import org.openecard.gui.StepResult;
import org.openecard.gui.definition.BoxItem;
import org.openecard.gui.definition.Checkbox;
import org.openecard.gui.definition.Step;
import org.openecard.gui.executor.ExecutionResults;
import org.openecard.gui.executor.StepAction;
import org.openecard.gui.executor.StepActionResult;
import org.openecard.gui.executor.StepActionResultStatus;
import org.openecard.sal.protocol.eac.EACData;

public class CHATStepAction
extends StepAction {
    private final EACData eacData;

    public CHATStepAction(EACData eacData, Step step) {
        super(step);
        this.eacData = eacData;
    }

    @Override
    public StepActionResult perform(Map<String, ExecutionResults> oldResults, StepResult result) {
        if (result.isOK()) {
            this.processResult(oldResults);
            return new StepActionResult(StepActionResultStatus.NEXT);
        }
        return new StepActionResult(StepActionResultStatus.BACK);
    }

    private void processResult(Map<String, ExecutionResults> results) {
        List<String> dataGroupsNames = this.getDataGroupNames();
        List<String> specialFunctionsNames = this.getSpecialFunctionNames();
        ExecutionResults executionResults = results.get(this.getStepID());
        Checkbox cb = (Checkbox)executionResults.getResult("CHATCheckBoxs");
        CHAT selectedCHAT = this.eacData.requiredCHAT;
        for (BoxItem item : cb.getBoxItems()) {
            if (dataGroupsNames.contains(item.getName())) {
                selectedCHAT.setReadAccess(item.getName(), item.isChecked());
                continue;
            }
            if (!specialFunctionsNames.contains(item.getName())) continue;
            selectedCHAT.setSpecialFunction(item.getName(), item.isChecked());
        }
    }

    private List<String> getSpecialFunctionNames() {
        ArrayList<String> specialFunctionNames = new ArrayList<String>();
        for (CHAT.SpecialFunction dg : CHAT.SpecialFunction.values()) {
            specialFunctionNames.add(dg.name());
        }
        return specialFunctionNames;
    }

    private List<String> getDataGroupNames() {
        ArrayList<String> dataGroupNames = new ArrayList<String>();
        for (CHAT.DataGroup dg : CHAT.DataGroup.values()) {
            dataGroupNames.add(dg.name());
        }
        return dataGroupNames;
    }
}

