/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.manage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openecard.addon.AddonManager;
import org.openecard.addon.ClasspathRegistry;
import org.openecard.addon.CombiningRegistry;
import org.openecard.addon.FileRegistry;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.addon.manifest.AppExtensionSpecification;
import org.openecard.common.I18n;
import org.openecard.common.util.FileUtils;
import org.openecard.gui.graphics.GraphicsUtil;
import org.openecard.gui.graphics.OecLogoBgWhite;
import org.openecard.richclient.gui.manage.ActionEntryPanel;
import org.openecard.richclient.gui.manage.ActionPanel;
import org.openecard.richclient.gui.manage.AddonPanel;
import org.openecard.richclient.gui.manage.AddonSelectionModel;
import org.openecard.richclient.gui.manage.DefaultSettingsGroup;
import org.openecard.richclient.gui.manage.DefaultSettingsPanel;
import org.openecard.richclient.gui.manage.core.ConnectionSettingsAddon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final String LANGUAGE_CODE = System.getProperty("user.language");
    private static final Logger logger = LoggerFactory.getLogger(ManagementDialog.class);
    private static ManagementDialog runningDialog;
    private final I18n lang = I18n.getTranslation("addon");
    private final AddonManager manager;
    private final ClasspathRegistry cpReg;
    private final FileRegistry fileReg;
    private JPanel selectionPanel;
    private JPanel contentPane;
    private JList coreList;
    private JList addonList;
    private JPanel addonPanel;
    private JLabel lastImage;

    public static synchronized void showDialog(AddonManager manager) {
        if (runningDialog == null) {
            ManagementDialog dialog = new ManagementDialog(manager);
            dialog.addWindowListener(new WindowListener(){

                @Override
                public void windowOpened(WindowEvent e) {
                }

                @Override
                public void windowClosing(WindowEvent e) {
                }

                @Override
                public void windowClosed(WindowEvent e) {
                    runningDialog = null;
                }

                @Override
                public void windowIconified(WindowEvent e) {
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                }

                @Override
                public void windowActivated(WindowEvent e) {
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                }
            });
            dialog.setVisible(true);
            runningDialog = dialog;
        } else {
            runningDialog.toFront();
        }
    }

    public ManagementDialog(AddonManager manager) {
        this.manager = manager;
        this.cpReg = ((CombiningRegistry)manager.getRegistry()).getClasspathRegistry();
        this.fileReg = ((CombiningRegistry)manager.getRegistry()).getFileRegistry();
        Image logo = GraphicsUtil.createImage(OecLogoBgWhite.class, 147, 147);
        this.setIconImage(logo);
        this.setTitle(this.lang.translationForKey("addon.title", new Object[0]));
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(640, 420));
        this.setSize(730, 480);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        this.addonPanel = new JPanel(new BorderLayout(), true);
        this.contentPane.add((Component)this.addonPanel, "Center");
        this.selectionPanel = new JPanel();
        this.contentPane.add((Component)this.selectionPanel, "West");
        GridBagLayout selectionLayout = new GridBagLayout();
        selectionLayout.rowHeights = new int[]{0, 0, 0, 0};
        selectionLayout.columnWeights = new double[]{1.0};
        selectionLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0};
        this.selectionPanel.setLayout(selectionLayout);
        this.createCoreList();
        this.createAddonList();
        this.setupCoreList();
        this.setupAddonList();
        this.setLocationRelativeTo(null);
    }

    public void setLogo(@Nonnull Image logo) {
        if (this.lastImage != null) {
            this.selectionPanel.remove(this.lastImage);
        }
        this.lastImage = new JLabel(new ImageIcon(logo));
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.insets = new Insets(5, 0, 6, 10);
        labelConstraints.anchor = 11;
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 0;
        this.selectionPanel.add((Component)this.lastImage, labelConstraints);
        this.selectionPanel.revalidate();
        this.selectionPanel.repaint();
    }

    private void createCoreList() {
        JLabel label = new JLabel(this.lang.translationForKey("addon.list.core", new Object[0]));
        label.setFont(label.getFont().deriveFont(1));
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.insets = new Insets(5, 0, 5, 10);
        labelConstraints.anchor = 11;
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 1;
        this.selectionPanel.add((Component)label, labelConstraints);
        this.coreList = new JList();
        this.coreList.setFont(this.coreList.getFont().deriveFont(0));
        this.coreList.setSelectionMode(0);
        GridBagConstraints coreListConstraints = new GridBagConstraints();
        coreListConstraints.fill = 2;
        coreListConstraints.insets = new Insets(0, 5, 5, 10);
        coreListConstraints.anchor = 11;
        coreListConstraints.gridx = 0;
        coreListConstraints.gridy = 2;
        AddonSelectionModel model = new AddonSelectionModel(this, this.addonPanel);
        this.coreList.setModel(model);
        this.coreList.addListSelectionListener(model);
        this.addWindowListener(model);
        model.addElement(this.lang.translationForKey("addon.list.core.connection", new Object[0]), new ConnectionSettingsAddon());
        for (AddonSpecification desc : this.cpReg.listPlugins()) {
            ArrayList<AppExtensionSpecification> applicationActions = desc.getApplicationActions();
            if (applicationActions.size() <= 0) continue;
            String description = desc.getLocalizedDescription(LANGUAGE_CODE);
            String name = desc.getLocalizedName(LANGUAGE_CODE);
            Image logo = ManagementDialog.loadLogo(desc.getLogo());
            ActionPanel actionPanel = this.createActionPanel(desc);
            AddonPanel addonPanel = new AddonPanel(actionPanel, name, description, logo);
            model.addElement(name, addonPanel);
        }
        this.selectionPanel.add((Component)this.coreList, coreListConstraints);
    }

    private ActionPanel createActionPanel(AddonSpecification desc) {
        ActionPanel actionPanel = new ActionPanel();
        for (AppExtensionSpecification action : desc.getApplicationActions()) {
            ActionEntryPanel actionEntryPanel = new ActionEntryPanel(desc, action, this.manager);
            actionPanel.addActionEntry(actionEntryPanel);
        }
        return actionPanel;
    }

    private static Image loadLogo(String logoPath) {
        try {
            String fName = logoPath;
            InputStream in = FileUtils.resolveResourceAsStream(ManagementDialog.class, fName);
            ImageIcon icon = new ImageIcon(FileUtils.toByteArray(in));
            return icon.getImage();
        }
        catch (IOException ex) {
            return null;
        }
    }

    private void createAddonList() {
        JLabel label = new JLabel(this.lang.translationForKey("addon.list.addon", new Object[0]));
        label.setFont(label.getFont().deriveFont(1));
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.insets = new Insets(5, 0, 5, 10);
        labelConstraints.anchor = 11;
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 3;
        this.selectionPanel.add((Component)label, labelConstraints);
        this.addonList = new JList();
        this.addonList.setFont(this.addonList.getFont().deriveFont(0));
        this.addonList.setSelectionMode(0);
        GridBagConstraints addonListConstraints = new GridBagConstraints();
        addonListConstraints.insets = new Insets(0, 5, 5, 10);
        addonListConstraints.fill = 2;
        addonListConstraints.anchor = 11;
        addonListConstraints.gridx = 0;
        addonListConstraints.gridy = 4;
        AddonSelectionModel model = new AddonSelectionModel(this, this.addonPanel);
        this.addonList.setModel(model);
        this.addonList.addListSelectionListener(model);
        this.addWindowListener(model);
        for (AddonSpecification desc : this.fileReg.listPlugins()) {
            String description = desc.getLocalizedDescription(LANGUAGE_CODE);
            String name = desc.getLocalizedName(LANGUAGE_CODE);
            Image logo = ManagementDialog.loadLogo(desc.getLogo());
            Properties properties = new Properties();
            try {
                File config = new File(FileUtils.getHomeConfigDir().getAbsolutePath() + File.separatorChar + "plugins" + File.separatorChar + desc.getId() + ".properties");
                if (config.exists()) {
                    properties.load(new FileReader(config));
                } else {
                    logger.debug("A properties file for the addon with id {} does not yet exist", (Object)desc.getId());
                }
            }
            catch (SecurityException e) {
                logger.error("Failed to load properties file for addon with id " + desc.getId(), e);
            }
            catch (IOException e) {
                logger.error("Failed to load properties file for addon with id " + desc.getId(), e);
            }
            DefaultSettingsGroup settingsGroup = new DefaultSettingsGroup("", properties, desc);
            AddonPanel addonPanel = new AddonPanel(new DefaultSettingsPanel(settingsGroup), name, description, logo);
            model.addElement(name, addonPanel);
        }
        this.selectionPanel.add((Component)this.addonList, addonListConstraints);
    }

    private void setupCoreList() {
        this.coreList.addListSelectionListener(new ClearSelectionListener(this.addonList));
        this.coreList.setSelectedIndex(0);
    }

    private void setupAddonList() {
        this.addonList.addListSelectionListener(new ClearSelectionListener(this.coreList));
    }

    private class ClearSelectionListener
    implements ListSelectionListener {
        private final JList otherList;

        public ClearSelectionListener(JList otherList) {
            this.otherList = otherList;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Object source = e.getSource();
            if (source instanceof JComponent) {
                JComponent component = (JComponent)source;
                if (!e.getValueIsAdjusting() && component.hasFocus()) {
                    this.otherList.clearSelection();
                }
            }
        }
    }
}

