/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.manage;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.addon.manifest.ConfigurationEntry;
import org.openecard.addon.manifest.ScalarEntry;
import org.openecard.addon.manifest.ScalarListEntry;
import org.openecard.common.util.FileUtils;
import org.openecard.richclient.gui.manage.SettingsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultSettingsGroup
extends SettingsGroup {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSettingsGroup.class);
    private static final long serialVersionUID = 1L;
    private static final String LANGUAGE_CODE = System.getProperty("user.language");
    private AddonSpecification desc;

    DefaultSettingsGroup(String title, Properties properties, AddonSpecification desc) {
        super(title, properties);
        this.desc = desc;
        for (ConfigurationEntry entry : desc.getConfigDescription().getEntries()) {
            String name = entry.getLocalizedName(LANGUAGE_CODE);
            String description = entry.getLocalizedDescription(LANGUAGE_CODE);
            if (entry instanceof ScalarEntry) {
                ScalarEntry scalarEntry = (ScalarEntry)entry;
                if (scalarEntry.getType().equalsIgnoreCase("string")) {
                    this.addInputItem(name, description, entry.getKey());
                    continue;
                }
                if (scalarEntry.getType().equalsIgnoreCase("boolean")) {
                    this.addBoolItem(name, description, entry.getKey());
                    continue;
                }
                logger.error("Untreated ScalarEntry type: {}", (Object)scalarEntry.getType());
                continue;
            }
            if (entry instanceof ScalarListEntry) {
                this.addListInputItem(name, description, entry.getKey());
                continue;
            }
            logger.error("Untreated entry type: {}", (Object)entry.getClass().getName());
        }
    }

    @Override
    protected void saveProperties() throws IOException, SecurityException {
        String path = FileUtils.getHomeConfigDir().getAbsolutePath() + File.separatorChar + "plugins" + File.separatorChar + this.desc.getId() + ".properties";
        File config = new File(path);
        FileWriter writer = new FileWriter(config);
        this.properties.store(writer, null);
    }
}

