/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.protocol.pace.common;

public enum PasswordID {
    MRZ(1),
    CAN(2),
    PIN(3),
    PUK(4);

    private byte b;

    private PasswordID(byte type) {
        this.b = type;
    }

    public static PasswordID parse(String type) {
        if (type.matches("[1-4]")) {
            return PasswordID.parse(Integer.valueOf(type).byteValue());
        }
        return PasswordID.valueOf(type);
    }

    public static PasswordID parse(byte type) {
        switch (type) {
            case 1: {
                return MRZ;
            }
            case 2: {
                return CAN;
            }
            case 3: {
                return PIN;
            }
            case 4: {
                return PUK;
            }
        }
        return null;
    }

    public String getString() {
        return this.name();
    }

    public byte getByte() {
        return this.b;
    }

    public String getByteAsString() {
        return this.getByte() + "";
    }
}

