/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.openecard.gui.definition.AbstractTextField;
import org.openecard.gui.definition.OutputInfoUnit;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.definition.TextField;
import org.openecard.gui.swing.components.StepComponent;

public class AbstractInput
implements StepComponent {
    private final String name;
    private final int minLength;
    private final int maxLength;
    private final JPanel panel;
    private final JLabel label;
    private final JTextComponent textField;
    private final AbstractTextField result;

    public AbstractInput(TextField input) {
        this(input, new TextField(input.getID()), new JTextField(20));
    }

    public AbstractInput(PasswordField input) {
        this(input, new PasswordField(input.getID()), new JPasswordField(12));
    }

    private AbstractInput(AbstractTextField input, AbstractTextField output, JTextComponent textFieldImpl) {
        this.name = input.getID();
        this.minLength = input.getMinLength();
        this.maxLength = input.getMaxLength();
        String value = input.getValue();
        String labelText = input.getDescription();
        this.result = output;
        this.result.setMinLength(this.minLength);
        this.result.setMaxLength(this.maxLength);
        this.result.setDescription(labelText);
        this.textField = textFieldImpl;
        if (value != null) {
            this.textField.setText(value);
            this.textField.selectAll();
        }
        this.label = new JLabel();
        this.label.setMinimumSize(new Dimension(100, 0));
        this.label.setMaximumSize(new Dimension(100, 50));
        this.label.setSize(100, this.label.getSize().height);
        if (labelText != null) {
            this.label.setText(labelText);
        }
        this.panel = new JPanel();
        FlowLayout panelLayout = new FlowLayout(0);
        this.panel.setLayout(panelLayout);
        this.panel.add(this.label);
        this.panel.add(this.textField);
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    public boolean validate() {
        int textSize;
        String textValue = this.textField.getText();
        if (textValue == null) {
            textValue = "";
        }
        return this.minLength <= (textSize = textValue.length()) && textSize <= this.maxLength;
    }

    @Override
    public boolean isValueType() {
        return true;
    }

    @Override
    public OutputInfoUnit getValue() {
        String textValue = this.textField.getText();
        if (textValue == null) {
            textValue = "";
        }
        this.result.setValue(textValue);
        return this.result;
    }
}

