/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.openecard.gui.FileDialog;
import org.openecard.gui.MessageDialog;
import org.openecard.gui.UserConsent;
import org.openecard.gui.UserConsentNavigator;
import org.openecard.gui.definition.Step;
import org.openecard.gui.definition.UserConsentDescription;
import org.openecard.gui.swing.DialogWrapper;
import org.openecard.gui.swing.Logo;
import org.openecard.gui.swing.NavigationBar;
import org.openecard.gui.swing.StepBar;
import org.openecard.gui.swing.SwingFileDialog;
import org.openecard.gui.swing.SwingMessageDialog;
import org.openecard.gui.swing.SwingNavigator;

public class SwingUserConsent
implements UserConsent {
    private final DialogWrapper dialogWrapper;

    public SwingUserConsent(DialogWrapper dialogWrapper) {
        this.dialogWrapper = dialogWrapper;
    }

    @Override
    public UserConsentNavigator obtainNavigator(UserConsentDescription parameters) {
        this.dialogWrapper.setTitle(parameters.getTitle());
        Container rootPanel = this.dialogWrapper.getContentPane();
        rootPanel.removeAll();
        String dialogType = parameters.getDialogType();
        List<Step> steps = parameters.getSteps();
        JPanel stepPanel = new JPanel(new BorderLayout());
        JPanel sideBar = new JPanel();
        StepBar stepBar = new StepBar(steps);
        final NavigationBar navigationBar = new NavigationBar(steps.size());
        Logo l = new Logo();
        this.initializeSidePanel(sideBar, l, stepBar);
        final SwingNavigator navigator = new SwingNavigator(this.dialogWrapper, dialogType, steps, stepPanel, navigationBar, stepBar);
        navigationBar.registerEvents(navigator);
        EventQueue eventQueue = new EventQueue(){
            ActionEvent e;
            {
                this.e = new ActionEvent(navigationBar, 1001, "Button.next");
            }

            @Override
            protected void dispatchEvent(AWTEvent event) {
                KeyEvent keyEvent;
                if (event instanceof KeyEvent && 402 == (keyEvent = (KeyEvent)event).getID() && 10 == keyEvent.getKeyCode() && !navigationBar.hasFocus()) {
                    navigator.actionPerformed(this.e);
                }
                super.dispatchEvent(event);
            }
        };
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(eventQueue);
        GroupLayout layout = new GroupLayout(rootPanel);
        rootPanel.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(sideBar, 200, 200, 200).addGroup(layout.createParallelGroup().addComponent(stepPanel).addComponent(navigationBar)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(sideBar).addGroup(layout.createSequentialGroup().addComponent(stepPanel).addComponent(navigationBar)));
        rootPanel.validate();
        rootPanel.repaint();
        return navigator;
    }

    @Override
    public FileDialog obtainFileDialog() {
        return new SwingFileDialog();
    }

    @Override
    public MessageDialog obtainMessageDialog() {
        return new SwingMessageDialog();
    }

    private void initializeSidePanel(JPanel panel, JComponent ... components) {
        panel.setLayout(new BoxLayout(panel, 3));
        for (JComponent c : components) {
            c.setAlignmentX(0.0f);
            panel.add(c);
        }
    }
}

