/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.module.tctoken;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.StartPAOS;
import iso.std.iso_iec._24727.tech.schema.StartPAOSResponse;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.concurrent.Callable;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.interfaces.DispatcherException;
import org.openecard.control.module.tctoken.ConnectionError;
import org.openecard.control.module.tctoken.TCTokenRequest;
import org.openecard.control.module.tctoken.TlsConnectionHandler;
import org.openecard.transport.paos.PAOS;
import org.openecard.transport.paos.PAOSException;

public class PAOSTask
implements Callable<StartPAOSResponse> {
    private final Dispatcher dispatcher;
    private final ConnectionHandleType connectionHandle;
    private final TCTokenRequest tokenRequest;

    public PAOSTask(Dispatcher dispatcher, ConnectionHandleType connectionHandle, TCTokenRequest tokenRequest) {
        this.dispatcher = dispatcher;
        this.connectionHandle = connectionHandle;
        this.tokenRequest = tokenRequest;
    }

    @Override
    public StartPAOSResponse call() throws MalformedURLException, PAOSException, DispatcherException, InvocationTargetException, ConnectionError {
        TlsConnectionHandler tlsHandler = new TlsConnectionHandler(this.dispatcher, this.tokenRequest, this.connectionHandle);
        tlsHandler.setUpClient();
        PAOS p = new PAOS(this.dispatcher, tlsHandler);
        StartPAOS sp = new StartPAOS();
        sp.setProfile("http://www.bsi.bund.de/ecard/api/1.1");
        sp.getConnectionHandle().add(this.connectionHandle);
        sp.setSessionIdentifier(tlsHandler.getSessionId());
        return p.sendStartPAOS(sp);
    }
}

