/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.module.status;

import iso.std.iso_iec._24727.tech.schema.CardApplicationType;
import iso.std.iso_iec._24727.tech.schema.CardInfoType;
import iso.std.iso_iec._24727.tech.schema.ChannelHandleType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.DIDInfoType;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openecard.addon.EventHandler;
import org.openecard.common.Version;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.control.module.status.StatusRequest;
import org.openecard.recognition.CardRecognition;
import org.openecard.ws.schema.Status;
import org.openecard.ws.schema.StatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusHandler {
    private static final Logger logger = LoggerFactory.getLogger(StatusHandler.class);
    private CardStateMap cardStates;
    private EventHandler eventHandler;
    private List<String> protocols;
    private CardRecognition rec;

    public StatusHandler(CardStateMap cardStates, EventHandler eventHandler, List<String> protocols, CardRecognition rec) {
        this.cardStates = cardStates;
        this.eventHandler = eventHandler;
        this.protocols = protocols;
        this.rec = rec;
    }

    public Status handleRequest(StatusRequest statusRequest) {
        String sessionIdentifier = statusRequest.getSessionIdentifier();
        Status status = new Status();
        ConnectionHandleType handle = new ConnectionHandleType();
        StatusType.UserAgent ua = new StatusType.UserAgent();
        ua.setName("Open eCard App");
        ua.setVersionMajor(BigInteger.valueOf(Version.getMajor()));
        ua.setVersionMinor(BigInteger.valueOf(Version.getMinor()));
        ua.setVersionSubminor(BigInteger.valueOf(Version.getPatch()));
        status.setUserAgent(ua);
        StatusType.SupportedAPIVersions apiVersion = new StatusType.SupportedAPIVersions();
        apiVersion.setName("http://www.bsi.bund.de/ecard/api");
        apiVersion.setVersionMajor(BigInteger.ONE);
        apiVersion.setVersionMinor(BigInteger.ONE);
        status.getSupportedAPIVersions().add(apiVersion);
        List<CardInfoType> cifs = this.rec.getCardInfos();
        List<StatusType.SupportedCards> supportedCards = StatusHandler.getSupportedCards(this.protocols, cifs);
        status.getSupportedCards().addAll(supportedCards);
        status.getSupportedDIDProtocols().addAll(this.protocols);
        if (sessionIdentifier != null) {
            ChannelHandleType channelHandle = new ChannelHandleType();
            channelHandle.setSessionIdentifier(sessionIdentifier);
            handle.setChannelHandle(channelHandle);
            this.eventHandler.addQueue(sessionIdentifier);
        }
        Set<CardStateEntry> entries = this.cardStates.getMatchingEntries(handle);
        for (CardStateEntry entry : entries) {
            status.getConnectionHandle().add(entry.handleCopy());
        }
        return status;
    }

    public StatusRequest parseStatusRequestURI(URI requestURI) throws UnsupportedEncodingException, MalformedURLException {
        String[] query;
        StatusRequest statusRequest = new StatusRequest();
        if (requestURI.getQuery() == null) {
            return statusRequest;
        }
        for (String q : query = requestURI.getQuery().split("&")) {
            String name = q.substring(0, q.indexOf(61));
            String value = q.substring(q.indexOf(61) + 1, q.length());
            if (name.startsWith("session")) {
                if (!value.isEmpty()) {
                    value = URLDecoder.decode(value, "UTF-8");
                    statusRequest.setSessionIdentifier(value);
                    continue;
                }
                throw new MalformedURLException("Value for session parameter is missing.");
            }
            logger.debug("Unknown query element: {}", (Object)name);
        }
        return statusRequest;
    }

    private static List<StatusType.SupportedCards> getSupportedCards(List<String> protocols, List<CardInfoType> cifs) {
        ArrayList<StatusType.SupportedCards> result = new ArrayList<StatusType.SupportedCards>();
        for (CardInfoType cif : cifs) {
            StatusType.SupportedCards supportedCard = new StatusType.SupportedCards();
            result.add(supportedCard);
            String name = cif.getCardType().getObjectIdentifier();
            supportedCard.setCardType(name);
            for (CardApplicationType app : cif.getApplicationCapabilities().getCardApplication()) {
                for (DIDInfoType did : app.getDIDInfo()) {
                    String proto = did.getDifferentialIdentity().getDIDProtocol();
                    if (!protocols.contains(proto) || supportedCard.getDIDProtocols().contains(proto)) continue;
                    supportedCard.getDIDProtocols().add(proto);
                }
            }
        }
        return result;
    }
}

