/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import java.security.SecureRandom;
import java.util.UUID;
import org.openecard.common.util.ByteUtils;

public class ValueGenerators {
    public static String generatePSK() {
        return ValueGenerators.generatePSK(64);
    }

    public static String generatePSK(int bitLength) {
        return ValueGenerators.generateRandomHex(bitLength);
    }

    public static String generateSessionID() {
        return ValueGenerators.generateSessionID(32);
    }

    public static String generateSessionID(int bitLength) {
        return ValueGenerators.generateRandomHex(bitLength);
    }

    public static String generateUUID() {
        String uuid = UUID.randomUUID().toString();
        return "urn:uuid:" + uuid;
    }

    public static String generateRandomHex(int bitLength) {
        return ByteUtils.toHexString(ValueGenerators.generateRandom(bitLength));
    }

    public static byte[] generateRandom(int bitLength) {
        if (bitLength < 1) {
            return null;
        }
        bitLength = bitLength / 2 + bitLength % 2;
        SecureRandom rand = new SecureRandom();
        byte[] randomBytes = new byte[bitLength];
        rand.nextBytes(randomBytes);
        return randomBytes;
    }
}

