/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import java.util.LinkedList;
import java.util.List;
import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.TLVBitString;
import org.openecard.common.tlv.iso7816.TLVList;
import org.openecard.common.tlv.iso7816.TLVType;
import org.openecard.common.util.ByteUtils;

public class CommonKeyAttributes
extends TLVType {
    private byte[] id;
    private TLVBitString usage;
    private boolean nativeFlag = true;
    private TLVBitString accessFlags;
    private Integer keyReference;
    private TLV startDate;
    private TLV endDate;
    private List<Integer> algRefs;

    public CommonKeyAttributes(TLV tlv) throws TLVException {
        super(tlv);
        Parser p = new Parser(tlv.getChild());
        if (!p.match(Tag.OCTETSTRING_TAG)) {
            throw new TLVException("No id element in structure.");
        }
        this.id = p.next(0).getValue();
        if (!p.match(Tag.BITSTRING_TAG)) {
            throw new TLVException("No usage element in structure.");
        }
        this.usage = new TLVBitString(p.next(0));
        if (p.match(Tag.BOOLEAN_TAG)) {
            boolean bl = this.nativeFlag = p.next(0).getValue()[0] != 0;
        }
        if (p.match(Tag.BITSTRING_TAG)) {
            this.accessFlags = new TLVBitString(p.next(0));
        }
        if (p.match(Tag.INTEGER_TAG)) {
            this.keyReference = ByteUtils.toInteger(p.next(0).getValue());
        }
        if (p.match(new Tag(TagClass.UNIVERSAL, true, 24L))) {
            this.startDate = p.next(0);
        }
        if (p.match(new Tag(TagClass.CONTEXT, true, 0L))) {
            this.endDate = p.next(0);
        }
        if (p.match(new Tag(TagClass.CONTEXT, false, 1L))) {
            TLVList list = new TLVList(p.next(0), new Tag(TagClass.CONTEXT, false, 1L).getTagNumWithClass());
            this.algRefs = new LinkedList<Integer>();
            for (TLV next : list.getContent()) {
                this.algRefs.add(ByteUtils.toInteger(next.getValue()));
            }
        }
    }
}

