/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.CardFlags;
import org.openecard.common.tlv.iso7816.TLVList;
import org.openecard.common.util.ByteUtils;

public class CIAInfo
extends TLV {
    private long version;
    private byte[] serialNumber;
    private String manufacturerID;
    private String label;
    private CardFlags cardFlags;
    private List<TLV> seInfo;
    private TLV recordInfo;
    private List<TLV> supportedAlgorithms;
    private String issuerId;
    private String holderId;
    private TLV lastUpdate;
    private String preferredLanguage;
    private List<TLV> profileIndication;

    public CIAInfo(TLV tlv) throws TLVException {
        super(tlv);
        if (tlv.getTagNumWithClass() != Tag.SEQUENCE_TAG.getTagNumWithClass()) {
            throw new TLVException("Data doesn't represent a CIAInfo structure.");
        }
        Parser p = new Parser(tlv.getChild());
        if (!p.match(new Tag(TagClass.UNIVERSAL, true, 2L))) {
            throw new TLVException("Expected version tag.");
        }
        this.version = ByteUtils.toLong(p.next(0).getValue());
        this.serialNumber = null;
        if (p.match(new Tag(TagClass.UNIVERSAL, true, 4L))) {
            this.serialNumber = p.next(0).getValue();
        }
        this.manufacturerID = null;
        if (p.match(new Tag(TagClass.UNIVERSAL, true, 12L))) {
            this.manufacturerID = new String(p.next(0).getValue(), Charset.forName("UTF-8"));
        }
        this.label = null;
        if (p.match(new Tag(TagClass.CONTEXT, true, 0L))) {
            this.label = new String(p.next(0).getValue(), Charset.forName("UTF-8"));
        }
        if (!p.match(new Tag(TagClass.UNIVERSAL, true, 3L))) {
            throw new TLVException("Expected cardflags tag.");
        }
        this.cardFlags = new CardFlags(p.next(0));
        this.seInfo = new LinkedList<TLV>();
        if (p.match(new Tag(TagClass.UNIVERSAL, false, 16L))) {
            this.seInfo = new TLVList(p.next(0), new Tag(TagClass.UNIVERSAL, false, 16L).getTagNumWithClass()).getContent();
        }
        this.recordInfo = null;
        if (p.match(new Tag(TagClass.CONTEXT, false, 1L))) {
            this.recordInfo = p.next(0);
        }
        this.supportedAlgorithms = new LinkedList<TLV>();
        if (p.match(new Tag(TagClass.CONTEXT, false, 2L))) {
            this.supportedAlgorithms = new TLVList(p.next(0).getChild(), Tag.SEQUENCE_TAG.getTagNumWithClass()).getContent();
        }
        this.issuerId = null;
        if (p.match(new Tag(TagClass.CONTEXT, true, 3L))) {
            this.issuerId = new String(p.next(0).getValue(), Charset.forName("UTF-8"));
        }
        this.holderId = null;
        if (p.match(new Tag(TagClass.CONTEXT, true, 4L))) {
            this.holderId = new String(p.next(0).getValue(), Charset.forName("UTF-8"));
        }
        this.lastUpdate = null;
        if (p.match(new Tag(TagClass.CONTEXT, false, 5L))) {
            this.lastUpdate = p.next(0);
        }
        this.preferredLanguage = null;
        if (p.match(new Tag(TagClass.UNIVERSAL, true, 19L))) {
            this.preferredLanguage = new String(p.next(0).getValue(), Charset.forName("UTF-8"));
        }
        this.profileIndication = new LinkedList<TLV>();
        if (p.match(new Tag(TagClass.CONTEXT, false, 6L))) {
            this.profileIndication = new TLVList(p.next(0), new Tag(TagClass.CONTEXT, false, 6L).getTagNumWithClass()).getContent();
        }
    }

    public long getVersion() {
        return this.version;
    }

    public byte[] getSerialNumber() {
        return this.serialNumber;
    }

    public String getManufacturerID() {
        return this.manufacturerID;
    }

    public String getLabel() {
        return this.label;
    }

    public CardFlags getCardFlags() {
        return this.cardFlags;
    }

    public List<TLV> getSeInfo() {
        return this.seInfo;
    }

    public TLV getRecordInfo() {
        return this.recordInfo;
    }

    public List<TLV> getSupportedAlgorithms() {
        return this.supportedAlgorithms;
    }

    public String getIssuerId() {
        return this.issuerId;
    }

    public String getHolderId() {
        return this.holderId;
    }

    public TLV getLastUpdate() {
        return this.lastUpdate;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public List<TLV> getProfileIndication() {
        return this.profileIndication;
    }
}

