/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.sal.util;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.DIDScopeType;
import iso.std.iso_iec._24727.tech.schema.DIDStructureType;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import org.openecard.common.ECardException;
import org.openecard.common.sal.Assert;
import org.openecard.common.sal.exception.NamedEntityNotFoundException;
import org.openecard.common.sal.exception.UnknownConnectionHandleException;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.common.sal.state.cif.CardApplicationWrapper;

public class SALUtils {
    public static ConnectionHandleType getConnectionHandle(Object object) throws ECardException, Exception {
        ConnectionHandleType value = (ConnectionHandleType)SALUtils.get(object, "getConnectionHandle");
        Assert.assertIncorrectParameter(value, "The parameter ConnectionHandle is empty.");
        return value;
    }

    public static String getDIDName(Object object) throws ECardException, Exception {
        String value = (String)SALUtils.get(object, "getDIDName");
        Assert.assertIncorrectParameter(value, "The parameter DIDName is empty.");
        return value;
    }

    public static DIDStructureType getDIDStructure(Object object, String didName, CardStateEntry entry, ConnectionHandleType connectionHandle) throws NamedEntityNotFoundException, Exception {
        DIDScopeType didScope = (DIDScopeType)((Object)SALUtils.get(object, "getDIDScope"));
        DIDStructureType didStructure = null;
        if (didScope != null && didScope.equals((Object)DIDScopeType.GLOBAL)) {
            CardApplicationWrapper app;
            Iterator<CardApplicationWrapper> i$ = entry.getInfo().getCardApplications().values().iterator();
            while (i$.hasNext() && (didStructure = entry.getDIDStructure(didName, (app = i$.next()).getApplicationIdentifier())) == null) {
            }
        } else {
            didStructure = entry.getDIDStructure(didName, connectionHandle.getCardApplication());
        }
        Assert.assertNamedEntityNotFound(didStructure, "The given DIDName cannot be found.");
        return didStructure;
    }

    public static CardStateEntry getCardStateEntry(CardStateMap states, ConnectionHandleType connectionHandle) throws UnknownConnectionHandleException {
        return SALUtils.getCardStateEntry(states, connectionHandle, true);
    }

    public static CardStateEntry getCardStateEntry(CardStateMap states, ConnectionHandleType connectionHandle, boolean filterAppId) throws UnknownConnectionHandleException {
        CardStateEntry value = states.getEntry(connectionHandle, filterAppId);
        if (value == null) {
            throw new UnknownConnectionHandleException(connectionHandle);
        }
        return value;
    }

    public static CardStateEntry getCardStateEntry(Map<String, Object> internalData, ConnectionHandleType connectionHandle) throws UnknownConnectionHandleException {
        CardStateEntry value = (CardStateEntry)internalData.get("cardState");
        if (value == null) {
            throw new UnknownConnectionHandleException(connectionHandle);
        }
        return value;
    }

    private static Object get(Object object, String method) throws Exception {
        Method[] methodes;
        for (Method m : methodes = object.getClass().getDeclaredMethods()) {
            if (!m.getName().equals(method)) continue;
            return m.invoke(object, new Object[0]);
        }
        return null;
    }
}

