/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.apdu.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.ShortUtils;

public class CardCommandStatus {
    private static final String defaultMsg = "Unknown status word (possibly proprietary).";
    private static final String sw62 = "State of non-volatile memory unchanged.";
    private static final String sw63 = "State of non-volatile memory changed.";
    private static final String sw64 = "State of non-volatile memory unchanged.";
    private static final String sw65 = "State of non-volatile memory changed.";
    private static final String sw66 = "Security related issues.";
    private static final String sw67 = "Wrong length without further indication.";
    private static final String sw68 = "Functions in CLA not supported.";
    private static final String sw69 = "Command not allowed.";
    private static final String sw6A = "Wrong parameters P1-P2.";
    private static final String sw6B = "Wrong parameters P1-P2.";
    private static final String sw6C = "Wrong length field.";
    private static final String sw6D = "Instruction code not supported or invalid.";
    private static final String sw6E = "Class not supported.";
    private static final String sw6F = "No precise diagnosis.";

    public static String getMessage(byte[] status) {
        String msg = defaultMsg;
        block0 : switch (status[0]) {
            case -112: {
                switch (status[1]) {
                    case 0: {
                        msg = "No error.";
                    }
                }
                break;
            }
            case 97: {
                msg = "No error, but " + (0xFF & status[1]) + " bytes left to read.";
                break;
            }
            case 98: {
                switch (status[1]) {
                    case 0: {
                        msg = "State of non-volatile memory unchanged. No further information given.";
                        break block0;
                    }
                    case -127: {
                        msg = "State of non-volatile memory unchanged. Part of returned data may be corrupted.";
                        break block0;
                    }
                    case -126: {
                        msg = "State of non-volatile memory unchanged. End of file reached before reading requested number of bytes.";
                        break block0;
                    }
                    case -125: {
                        msg = "State of non-volatile memory unchanged. Selected file deactivated.";
                        break block0;
                    }
                    case -124: {
                        msg = "State of non-volatile memory unchanged. File control information not formatted according to ISO/IEC 7816-4.";
                        break block0;
                    }
                    case -123: {
                        msg = "State of non-volatile memory unchanged. Selected file in termination state.";
                        break block0;
                    }
                    case -122: {
                        msg = "State of non-volatile memory unchanged. No input data available from a sensor on the card.";
                        break block0;
                    }
                }
                if (status[1] < 2 || status[1] > 128) break;
                msg = "State of non-volatile memory unchanged. Triggering by the card (see ISO/IEC 7816-4 8.6.1).";
                break;
            }
            case 99: {
                switch (status[1]) {
                    case 0: {
                        msg = "State of non-volatile memory changed. No further information given.";
                        break block0;
                    }
                    case -127: {
                        msg = "State of non-volatile memory changed. File filled up by last write.";
                        break block0;
                    }
                }
                if (status[1] < 192 || status[1] > 207) break;
                msg = "State of non-volatile memory changed. Counter is " + (0xF & status[1]) + ".";
                break;
            }
            case 100: {
                switch (status[1]) {
                    case 0: {
                        msg = "State of non-volatile memory unchanged. Execution error.";
                        break block0;
                    }
                    case 1: {
                        msg = "State of non-volatile memory unchanged. Immediate response required by the card.";
                        break block0;
                    }
                }
                if (status[1] < 2 || status[1] > 128) break;
                msg = "State of non-volatile memory unchanged. Triggered by the card (see ISO/IEC 7816-4 8.6.1).";
                break;
            }
            case 101: {
                switch (status[1]) {
                    case 0: {
                        msg = "State of non-volatile memory changed. No information given.";
                        break;
                    }
                    case -127: {
                        msg = "State of non-volatile memory changed. Memory failure.";
                    }
                }
                break;
            }
            case 102: {
                msg = sw66;
                break;
            }
            case 103: {
                switch (status[1]) {
                    case 0: {
                        msg = sw67;
                    }
                }
                break;
            }
            case 104: {
                switch (status[1]) {
                    case 0: {
                        msg = "Functions in CLA not supported. No information given.";
                        break;
                    }
                    case -127: {
                        msg = "Functions in CLA not supported. Logical channel not supported.";
                        break;
                    }
                    case -126: {
                        msg = "Functions in CLA not supported. Secure messaging not supported.";
                        break;
                    }
                    case -125: {
                        msg = "Functions in CLA not supported. Last command of the chain expected.";
                        break;
                    }
                    case -124: {
                        msg = "Functions in CLA not supported. Command chaining not supported.";
                    }
                }
                break;
            }
            case 105: {
                switch (status[1]) {
                    case 0: {
                        msg = "Command not allowed. No information given.";
                        break;
                    }
                    case -127: {
                        msg = "Command not allowed. Command incompatible with file structure.";
                        break;
                    }
                    case -126: {
                        msg = "Command not allowed. Security status not satisfied.";
                        break;
                    }
                    case -125: {
                        msg = "Command not allowed. Authentication method blocked.";
                        break;
                    }
                    case -124: {
                        msg = "Command not allowed. Reference data not usable.";
                        break;
                    }
                    case -123: {
                        msg = "Command not allowed. Conditions of use not satisfied.";
                        break;
                    }
                    case -122: {
                        msg = "Command not allowed. Command not allowed (no current EF).";
                        break;
                    }
                    case -121: {
                        msg = "Command not allowed. Expected secure messaging data objects missing.";
                        break;
                    }
                    case -120: {
                        msg = "Command not allowed. Incorrect secure messaging data objects.";
                    }
                }
                break;
            }
            case 106: {
                switch (status[1]) {
                    case 0: {
                        msg = "Wrong parameters P1-P2. No information given.";
                        break;
                    }
                    case -128: {
                        msg = "Wrong parameters P1-P2. Incorrect parameters in the command data field.";
                        break;
                    }
                    case -127: {
                        msg = "Wrong parameters P1-P2. Function not supported.";
                        break;
                    }
                    case -126: {
                        msg = "Wrong parameters P1-P2. File or application not found.";
                        break;
                    }
                    case -125: {
                        msg = "Wrong parameters P1-P2. Record not found.";
                        break;
                    }
                    case -124: {
                        msg = "Wrong parameters P1-P2. Not enough memory space in the file.";
                        break;
                    }
                    case -123: {
                        msg = "Wrong parameters P1-P2. Command length inconsistent with TLV structure.";
                        break;
                    }
                    case -122: {
                        msg = "Wrong parameters P1-P2.";
                        break;
                    }
                    case -121: {
                        msg = "Wrong parameters P1-P2. Command length inconsistent with parameters P1-P2.";
                        break;
                    }
                    case -120: {
                        msg = "Wrong parameters P1-P2. Referenced data or reference data not found.";
                        break;
                    }
                    case -119: {
                        msg = "Wrong parameters P1-P2. File already exists.";
                        break;
                    }
                    case -118: {
                        msg = "Wrong parameters P1-P2. DF name already exists.";
                    }
                }
                break;
            }
            case 107: {
                switch (status[1]) {
                    case 0: {
                        msg = "Wrong parameters P1-P2.";
                    }
                }
                break;
            }
            case 108: {
                msg = "Wrong length field. " + (0xFF & status[1]) + " bytes available.";
                break;
            }
            case 109: {
                switch (status[1]) {
                    case 0: {
                        msg = sw6D;
                    }
                }
                break;
            }
            case 110: {
                switch (status[1]) {
                    case 0: {
                        msg = sw6E;
                    }
                }
                break;
            }
            case 111: {
                switch (status[1]) {
                    case 0: {
                        msg = sw6F;
                    }
                }
            }
        }
        msg = msg + " (Code: " + ByteUtils.toHexString(status) + ")";
        return msg;
    }

    public static byte[] ok() {
        return new byte[]{-112, 0};
    }

    public static List<byte[]> responseOk() {
        return CardCommandStatus.response(new byte[][]{CardCommandStatus.ok()});
    }

    public static List<byte[]> response(byte[] ... expected) {
        ArrayList<byte[]> result = new ArrayList<byte[]>(expected.length);
        result.addAll(Arrays.asList(expected));
        return result;
    }

    public static List<byte[]> response(int ... expected) {
        byte[][] conv = new byte[expected.length][];
        for (int i = 0; i < expected.length; ++i) {
            conv[i] = ShortUtils.toByteArray((short)expected[i], true);
        }
        return CardCommandStatus.response(conv);
    }
}

