/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.IOException;
import org.openecard.bouncycastle.crypto.BlockCipher;
import org.openecard.bouncycastle.crypto.Digest;
import org.openecard.bouncycastle.crypto.StreamCipher;
import org.openecard.bouncycastle.crypto.digests.MD5Digest;
import org.openecard.bouncycastle.crypto.digests.SHA1Digest;
import org.openecard.bouncycastle.crypto.digests.SHA256Digest;
import org.openecard.bouncycastle.crypto.digests.SHA384Digest;
import org.openecard.bouncycastle.crypto.digests.SHA512Digest;
import org.openecard.bouncycastle.crypto.engines.AESFastEngine;
import org.openecard.bouncycastle.crypto.engines.CamelliaEngine;
import org.openecard.bouncycastle.crypto.engines.DESedeEngine;
import org.openecard.bouncycastle.crypto.engines.RC4Engine;
import org.openecard.bouncycastle.crypto.engines.SEEDEngine;
import org.openecard.bouncycastle.crypto.modes.AEADBlockCipher;
import org.openecard.bouncycastle.crypto.modes.CBCBlockCipher;
import org.openecard.bouncycastle.crypto.modes.GCMBlockCipher;
import org.openecard.bouncycastle.crypto.tls.AbstractTlsCipherFactory;
import org.openecard.bouncycastle.crypto.tls.TlsAEADCipher;
import org.openecard.bouncycastle.crypto.tls.TlsBlockCipher;
import org.openecard.bouncycastle.crypto.tls.TlsCipher;
import org.openecard.bouncycastle.crypto.tls.TlsContext;
import org.openecard.bouncycastle.crypto.tls.TlsFatalAlert;
import org.openecard.bouncycastle.crypto.tls.TlsNullCipher;
import org.openecard.bouncycastle.crypto.tls.TlsStreamCipher;

public class DefaultTlsCipherFactory
extends AbstractTlsCipherFactory {
    @Override
    public TlsCipher createCipher(TlsContext context, int encryptionAlgorithm, int macAlgorithm) throws IOException {
        switch (encryptionAlgorithm) {
            case 7: {
                return this.createDESedeCipher(context, macAlgorithm);
            }
            case 8: {
                return this.createAESCipher(context, 16, macAlgorithm);
            }
            case 10: {
                return this.createCipher_AES_GCM(context, 16, 16);
            }
            case 9: {
                return this.createAESCipher(context, 32, macAlgorithm);
            }
            case 11: {
                return this.createCipher_AES_GCM(context, 32, 16);
            }
            case 12: {
                return this.createCamelliaCipher(context, 16, macAlgorithm);
            }
            case 13: {
                return this.createCamelliaCipher(context, 32, macAlgorithm);
            }
            case 0: {
                return this.createNullCipher(context, macAlgorithm);
            }
            case 2: {
                return this.createRC4Cipher(context, 16, macAlgorithm);
            }
            case 14: {
                return this.createSEEDCipher(context, macAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsBlockCipher createAESCipher(TlsContext context, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(context, this.createAESBlockCipher(), this.createAESBlockCipher(), this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm), cipherKeySize);
    }

    protected TlsAEADCipher createCipher_AES_GCM(TlsContext context, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(context, this.createAEADBlockCipher_AES_GCM(), this.createAEADBlockCipher_AES_GCM(), cipherKeySize, macSize);
    }

    protected TlsBlockCipher createCamelliaCipher(TlsContext context, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(context, this.createCamelliaBlockCipher(), this.createCamelliaBlockCipher(), this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm), cipherKeySize);
    }

    protected TlsNullCipher createNullCipher(TlsContext context, int macAlgorithm) throws IOException {
        return new TlsNullCipher(context, this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm));
    }

    protected TlsStreamCipher createRC4Cipher(TlsContext context, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsStreamCipher(context, this.createRC4StreamCipher(), this.createRC4StreamCipher(), this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm), cipherKeySize);
    }

    protected TlsBlockCipher createDESedeCipher(TlsContext context, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(context, this.createDESedeBlockCipher(), this.createDESedeBlockCipher(), this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm), 24);
    }

    protected TlsBlockCipher createSEEDCipher(TlsContext context, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(context, this.createSEEDBlockCipher(), this.createSEEDBlockCipher(), this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm), 16);
    }

    protected StreamCipher createRC4StreamCipher() {
        return new RC4Engine();
    }

    protected BlockCipher createAESBlockCipher() {
        return new CBCBlockCipher(new AESFastEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_GCM() {
        return new GCMBlockCipher(new AESFastEngine());
    }

    protected BlockCipher createCamelliaBlockCipher() {
        return new CBCBlockCipher(new CamelliaEngine());
    }

    protected BlockCipher createDESedeBlockCipher() {
        return new CBCBlockCipher(new DESedeEngine());
    }

    protected BlockCipher createSEEDBlockCipher() {
        return new CBCBlockCipher(new SEEDEngine());
    }

    protected Digest createHMACDigest(int macAlgorithm) throws IOException {
        switch (macAlgorithm) {
            case 0: {
                return null;
            }
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA256Digest();
            }
            case 4: {
                return new SHA384Digest();
            }
            case 5: {
                return new SHA512Digest();
            }
        }
        throw new TlsFatalAlert(80);
    }
}

