/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.openecard.bouncycastle.crypto.tls.AbstractTlsPeer;
import org.openecard.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import org.openecard.bouncycastle.crypto.tls.NewSessionTicket;
import org.openecard.bouncycastle.crypto.tls.ProtocolVersion;
import org.openecard.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.openecard.bouncycastle.crypto.tls.TlsCipherFactory;
import org.openecard.bouncycastle.crypto.tls.TlsClient;
import org.openecard.bouncycastle.crypto.tls.TlsClientContext;
import org.openecard.bouncycastle.crypto.tls.TlsCompression;
import org.openecard.bouncycastle.crypto.tls.TlsDeflateCompression;
import org.openecard.bouncycastle.crypto.tls.TlsFatalAlert;
import org.openecard.bouncycastle.crypto.tls.TlsNullCompression;
import org.openecard.bouncycastle.crypto.tls.TlsUtils;
import org.openecard.bouncycastle.util.Arrays;

public abstract class AbstractTlsClient
extends AbstractTlsPeer
implements TlsClient {
    protected TlsCipherFactory cipherFactory;
    protected TlsClientContext context;
    protected Vector supportedSignatureAlgorithms;
    protected Vector serverNames;
    protected int selectedCipherSuite;
    protected short selectedCompressionMethod;
    protected ProtocolVersion clientVersion = ProtocolVersion.TLSv11;
    protected byte[] sessionID;

    public AbstractTlsClient() {
        this(new DefaultTlsCipherFactory());
    }

    public AbstractTlsClient(TlsCipherFactory cipherFactory) {
        this.cipherFactory = cipherFactory;
    }

    public AbstractTlsClient(String fqdn) {
        this((TlsCipherFactory)new DefaultTlsCipherFactory(), fqdn);
    }

    public AbstractTlsClient(TlsCipherFactory cipherFactory, String fqdn) {
        this.cipherFactory = cipherFactory;
        if (fqdn != null) {
            this.serverNames = new Vector();
            this.serverNames.addElement(fqdn);
        }
    }

    public AbstractTlsClient(Vector serverNames) {
        this((TlsCipherFactory)new DefaultTlsCipherFactory(), serverNames);
    }

    public AbstractTlsClient(TlsCipherFactory cipherFactory, Vector serverNames) {
        this.cipherFactory = cipherFactory;
        this.serverNames = new Vector(serverNames);
    }

    @Override
    public void init(TlsClientContext context) {
        this.context = context;
    }

    @Override
    public byte[] getSessionID() {
        if (this.sessionID != null) {
            return Arrays.copyOf(this.sessionID, this.sessionID.length);
        }
        return new byte[0];
    }

    @Override
    public TlsClientContext getClientContext() {
        return this.context;
    }

    @Override
    public ProtocolVersion getClientHelloRecordLayerVersion() {
        return this.getClientVersion();
    }

    @Override
    public void setClientVersion(ProtocolVersion clientVersion) {
        this.clientVersion = clientVersion;
    }

    @Override
    public ProtocolVersion getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        Hashtable clientExtensions = new Hashtable();
        ProtocolVersion clientVersion = this.context.getClientVersion();
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(clientVersion)) {
            short[] hashAlgorithms = new short[]{6, 5, 4, 3, 2};
            short[] signatureAlgorithms = new short[]{1};
            this.supportedSignatureAlgorithms = new Vector();
            for (int i = 0; i < hashAlgorithms.length; ++i) {
                for (int j = 0; j < signatureAlgorithms.length; ++j) {
                    this.supportedSignatureAlgorithms.addElement(new SignatureAndHashAlgorithm(hashAlgorithms[i], signatureAlgorithms[j]));
                }
            }
            this.supportedSignatureAlgorithms.addElement(new SignatureAndHashAlgorithm(2, 2));
            TlsUtils.addSignatureAlgorithmsExtension(clientExtensions, this.supportedSignatureAlgorithms);
        }
        if (this.serverNames != null) {
            TlsUtils.addServerNameIndicationExtension(clientExtensions, this.serverNames);
        }
        return clientExtensions;
    }

    public ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.TLSv10;
    }

    @Override
    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        if (!this.getMinimumVersion().isEqualOrEarlierVersionOf(serverVersion)) {
            throw new TlsFatalAlert(70);
        }
    }

    @Override
    public short[] getCompressionMethods() {
        return new short[]{0, 1};
    }

    @Override
    public void notifySessionID(byte[] sessionID) {
        this.sessionID = Arrays.copyOf(sessionID, sessionID.length);
    }

    @Override
    public void notifySelectedCipherSuite(int selectedCipherSuite) {
        this.selectedCipherSuite = selectedCipherSuite;
    }

    @Override
    public void notifySelectedCompressionMethod(short selectedCompressionMethod) {
        this.selectedCompressionMethod = selectedCompressionMethod;
    }

    @Override
    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
        if (!secureRenegotiation) {
            // empty if block
        }
    }

    @Override
    public void processServerExtensions(Hashtable serverExtensions) throws IOException {
        if (serverExtensions != null && serverExtensions.containsKey(TlsUtils.EXT_signature_algorithms)) {
            throw new TlsFatalAlert(47);
        }
    }

    @Override
    public void processServerSupplementalData(Vector serverSupplementalData) throws IOException {
        if (serverSupplementalData != null) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public Vector getClientSupplementalData() throws IOException {
        return null;
    }

    @Override
    public TlsCompression getCompression() throws IOException {
        switch (this.selectedCompressionMethod) {
            case 0: {
                return new TlsNullCompression();
            }
            case 1: {
                return new TlsDeflateCompression();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public void notifyNewSessionTicket(NewSessionTicket newSessionTicket) throws IOException {
    }

    @Override
    public void notifyHandshakeComplete() throws IOException {
    }
}

