/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.signers;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.openecard.bouncycastle.crypto.CipherParameters;
import org.openecard.bouncycastle.crypto.DSA;
import org.openecard.bouncycastle.crypto.params.ECKeyParameters;
import org.openecard.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.openecard.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.openecard.bouncycastle.crypto.params.ParametersWithRandom;
import org.openecard.bouncycastle.math.ec.ECAlgorithms;
import org.openecard.bouncycastle.math.ec.ECConstants;
import org.openecard.bouncycastle.math.ec.ECPoint;

public class ECDSASigner
implements ECConstants,
DSA {
    ECKeyParameters key;
    SecureRandom random;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (ECPrivateKeyParameters)rParam.getParameters();
            } else {
                this.random = new SecureRandom();
                this.key = (ECPrivateKeyParameters)param;
            }
        } else {
            this.key = (ECPublicKeyParameters)param;
        }
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        BigInteger d;
        BigInteger k;
        BigInteger n = this.key.getParameters().getN();
        BigInteger e = this.calculateE(n, message);
        BigInteger r = null;
        BigInteger s = null;
        do {
            ECPoint p;
            BigInteger x;
            k = null;
            int nBitLength = n.bitLength();
            while ((k = new BigInteger(nBitLength, this.random)).equals(ZERO) || k.compareTo(n) >= 0 || (r = (x = (p = this.key.getParameters().getG().multiply(k)).getX().toBigInteger()).mod(n)).equals(ZERO)) {
            }
            d = ((ECPrivateKeyParameters)this.key).getD();
        } while ((s = k.modInverse(n).multiply(e.add(d.multiply(r))).mod(n)).equals(ZERO));
        BigInteger[] res = new BigInteger[]{r, s};
        return res;
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        ECPoint Q;
        BigInteger n = this.key.getParameters().getN();
        BigInteger e = this.calculateE(n, message);
        if (r.compareTo(ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s.compareTo(ONE) < 0 || s.compareTo(n) >= 0) {
            return false;
        }
        BigInteger c = s.modInverse(n);
        BigInteger u1 = e.multiply(c).mod(n);
        BigInteger u2 = r.multiply(c).mod(n);
        ECPoint G = this.key.getParameters().getG();
        ECPoint point = ECAlgorithms.sumOfTwoMultiplies(G, u1, Q = ((ECPublicKeyParameters)this.key).getQ(), u2);
        if (point.isInfinity()) {
            return false;
        }
        BigInteger v = point.getX().toBigInteger().mod(n);
        return v.equals(r);
    }

    private BigInteger calculateE(BigInteger n, byte[] message) {
        int messageBitLength;
        int log2n = n.bitLength();
        if (log2n >= (messageBitLength = message.length * 8)) {
            return new BigInteger(1, message);
        }
        BigInteger trunc = new BigInteger(1, message);
        trunc = trunc.shiftRight(messageBitLength - log2n);
        return trunc;
    }
}

